/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.ParameterDriver;

public abstract class BaseRangeRateTroposphericDelayModifier {
    private final DiscreteTroposphericModel tropoModel;

    protected BaseRangeRateTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    protected DiscreteTroposphericModel getTropoModel() {
        return this.tropoModel;
    }

    public double rangeRateErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation1 = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation1 > 0.0) {
            double d1 = this.tropoModel.pathDelay(elevation1, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            SpacecraftState state2 = state.shiftedBy(10.0);
            Vector3D position2 = state2.getPVCoordinates().getPosition();
            double elevation2 = station.getBaseFrame().getElevation(position2, state2.getFrame(), state2.getDate());
            double d2 = this.tropoModel.pathDelay(elevation2, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state2.getDate());
            return (d2 - d1) / 10.0;
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T rangeRateErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        double dt = 10.0;
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object elevation1 = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation1.getReal() > 0.0) {
            CalculusFieldElement d1 = this.tropoModel.pathDelay((CalculusFieldElement)elevation1, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            FieldTimeInterpolable state2 = state.shiftedBy(10.0);
            FieldVector3D position2 = ((FieldSpacecraftState)state2).getPVCoordinates().getPosition();
            Object elevation2 = station.getBaseFrame().getElevation(position2, ((FieldSpacecraftState)state2).getFrame(), ((FieldSpacecraftState)state2).getDate());
            CalculusFieldElement d2 = this.tropoModel.pathDelay((CalculusFieldElement)elevation2, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, ((FieldSpacecraftState)state2).getDate());
            return (T)((CalculusFieldElement)((CalculusFieldElement)d2.subtract((FieldElement)d1)).divide(10.0));
        }
        return (T)zero;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }
}

