/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.BistaticRange;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class BistaticRangeBuilder
extends AbstractMeasurementBuilder<BistaticRange> {
    private final GroundStation emitter;
    private final GroundStation receiver;

    public BistaticRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation emitter, GroundStation receiver, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.emitter = emitter;
        this.receiver = receiver;
    }

    @Override
    public BistaticRange build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{states[satellite.getPropagatorIndex()]};
        BistaticRange dummy = new BistaticRange(this.emitter, this.receiver, relevant[0].getDate(), Double.NaN, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimate(0, 0, relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        BistaticRange measurement = new BistaticRange(this.emitter, this.receiver, relevant[0].getDate(), range, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

