/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BistaticRange
extends AbstractMeasurement<BistaticRange> {
    private final GroundStation emitter;
    private final GroundStation receiver;

    public BistaticRange(GroundStation emitter, GroundStation receiver, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, range, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(emitter.getClockOffsetDriver());
        this.addParameterDriver(emitter.getEastOffsetDriver());
        this.addParameterDriver(emitter.getNorthOffsetDriver());
        this.addParameterDriver(emitter.getZenithOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianDriftDriver());
        this.addParameterDriver(emitter.getPolarOffsetXDriver());
        this.addParameterDriver(emitter.getPolarDriftXDriver());
        this.addParameterDriver(emitter.getPolarOffsetYDriver());
        this.addParameterDriver(emitter.getPolarDriftYDriver());
        this.addParameterDriver(receiver.getClockOffsetDriver());
        this.addParameterDriver(receiver.getEastOffsetDriver());
        this.addParameterDriver(receiver.getNorthOffsetDriver());
        this.addParameterDriver(receiver.getZenithOffsetDriver());
        this.addParameterDriver(receiver.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(receiver.getPrimeMeridianDriftDriver());
        this.addParameterDriver(receiver.getPolarOffsetXDriver());
        this.addParameterDriver(receiver.getPolarDriftXDriver());
        this.addParameterDriver(receiver.getPolarOffsetYDriver());
        this.addParameterDriver(receiver.getPolarDriftYDriver());
        this.emitter = emitter;
        this.receiver = receiver;
    }

    public GroundStation getEmitterStation() {
        return this.emitter;
    }

    public GroundStation getReceiverStation() {
        return this.receiver;
    }

    @Override
    protected EstimatedMeasurement<BistaticRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = BistaticRange.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> offsetToInertialRx = this.receiver.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> downlinkDateDS = offsetToInertialRx.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> stationReceiver = offsetToInertialRx.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(downlinkDateDS, zero, zero, zero));
        Gradient tauD = BistaticRange.signalTimeOfFlight(pvaDS, stationReceiver.getPosition(), downlinkDateDS);
        Gradient delta = downlinkDateDS.durationFrom(state.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((CalculusFieldElement)deltaMTauD);
        FieldAbsoluteDate<Gradient> transitDate = downlinkDateDS.shiftedBy(tauD.negate());
        FieldTransform<Gradient> offsetToInertialTxApprox = this.emitter.getOffsetToInertial(state.getFrame(), transitDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> transmitApprox = offsetToInertialTxApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(transitDate, zero, zero, zero));
        Gradient tauU = BistaticRange.signalTimeOfFlight(transmitApprox, transitStateDS.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateDS).getDate());
        Gradient tauTotal = deltaMTauD.negate().add(tauU);
        FieldAbsoluteDate<Gradient> transmitDateDS = downlinkDateDS.shiftedBy(tauTotal);
        FieldTransform<Gradient> transmitToInert = this.emitter.getOffsetToInertial(state.getFrame(), transmitDateDS, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> stationTransmitter = transmitToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(transmitDateDS, zero, zero, zero));
        EstimatedMeasurement<BistaticRange> estimated = new EstimatedMeasurement<BistaticRange>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{stationReceiver.toTimeStampedPVCoordinates(), ((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationTransmitter.toTimeStampedPVCoordinates()});
        Gradient tau = tauD.add(tauU);
        Gradient range = tau.multiply(2.99792458E8);
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }
}

