/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularRaDec
extends AbstractMeasurement<AngularRaDec> {
    private final GroundStation station;
    private final Frame referenceFrame;

    public AngularRaDec(GroundStation station, Frame referenceFrame, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(date, angular, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        this.station = station;
        this.referenceFrame = referenceFrame;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    protected EstimatedMeasurement<AngularRaDec> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            indices.put(driver.getName(), nbParams++);
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = AngularRaDec.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> downlinkDateDS = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(downlinkDateDS, zero, zero, zero));
        Gradient tauD = AngularRaDec.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        Gradient delta = downlinkDateDS.durationFrom(state.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitStateDS = pvaDS.shiftedBy((CalculusFieldElement)deltaMTauD);
        FieldVector3D staSatInertial = transitStateDS.getPosition().subtract(stationDownlink.getPosition());
        FieldTransform<Gradient> inertialToReferenceDownlink = state.getFrame().getTransformTo(this.referenceFrame, downlinkDateDS);
        FieldVector3D<Gradient> staSatReference = inertialToReferenceDownlink.transformPosition((FieldVector3D<Gradient>)staSatInertial);
        Gradient baseRightAscension = (Gradient)staSatReference.getAlpha();
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension.getReal(), (double)this.getObservedValue()[0]) - baseRightAscension.getReal();
        Gradient rightAscension = baseRightAscension.add(twoPiWrap);
        Gradient declination = (Gradient)staSatReference.getDelta();
        EstimatedMeasurement<AngularRaDec> estimated = new EstimatedMeasurement<AngularRaDec>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)transitStateDS).toTimeStampedPVCoordinates(), stationDownlink.toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(rightAscension.getValue(), declination.getValue());
        double[] raDerivatives = rightAscension.getGradient();
        double[] decDerivatives = declination.getGradient();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(raDerivatives, 0, 6), Arrays.copyOfRange(decDerivatives, 0, 6));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, raDerivatives[index], decDerivatives[index]);
        }
        return estimated;
    }
}

