/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiTheta;
import org.hipparchus.special.elliptic.jacobi.FieldTheta;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;

class FieldBoundedParameter<T extends CalculusFieldElement<T>>
extends FieldJacobiElliptic<T> {
    private final FieldJacobiTheta<T> jacobiTheta;
    private final FieldTheta<T> t0;
    private final T scaling;

    FieldBoundedParameter(T m) {
        super(m);
        T q = LegendreEllipticIntegral.nome(m);
        this.jacobiTheta = new FieldJacobiTheta<T>(q);
        this.t0 = this.jacobiTheta.values((CalculusFieldElement)m.getField().getZero());
        this.scaling = (CalculusFieldElement)((CalculusFieldElement)LegendreEllipticIntegral.bigK(m).reciprocal()).multiply(((CalculusFieldElement)m.getPi()).multiply(0.5));
    }

    @Override
    public FieldCopolarN<T> valuesN(T u) {
        FieldTheta<CalculusFieldElement> tZ = this.jacobiTheta.values((CalculusFieldElement)u.multiply(this.scaling));
        CalculusFieldElement sn = this.t0.theta3().multiply((CalculusFieldElement)tZ.theta1()).divide(this.t0.theta2().multiply((CalculusFieldElement)tZ.theta4()));
        CalculusFieldElement cn = this.t0.theta4().multiply((CalculusFieldElement)tZ.theta2()).divide(this.t0.theta2().multiply((CalculusFieldElement)tZ.theta4()));
        CalculusFieldElement dn = this.t0.theta4().multiply((CalculusFieldElement)tZ.theta3()).divide(this.t0.theta3().multiply((CalculusFieldElement)tZ.theta4()));
        return new FieldCopolarN<CalculusFieldElement>(sn, cn, dn);
    }
}

