/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.complex.ComplexField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public class Complex
implements CalculusFieldElement<Complex>,
Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex MINUS_I = new Complex(0.0, -1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex MINUS_ONE = new Complex(-1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex PI = new Complex(Math.PI, 0.0);
    private static final double LOG10 = 2.302585092994046;
    private static final long serialVersionUID = 20160305L;
    private final double imaginary;
    private final double real;
    private final transient boolean isNaN;
    private final transient boolean isInfinite;

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
        this.isNaN = Double.isNaN(real) || Double.isNaN(imaginary);
        this.isInfinite = !this.isNaN && (Double.isInfinite(real) || Double.isInfinite(imaginary));
    }

    @Override
    public Complex abs() {
        return this.isNaN ? NaN : this.createComplex(FastMath.hypot(this.real, this.imaginary), 0.0);
    }

    @Override
    public double norm() {
        return this.isNaN ? Double.NaN : FastMath.hypot(this.real, this.imaginary);
    }

    @Override
    public Complex add(Complex addend) throws NullArgumentException {
        MathUtils.checkNotNull(addend);
        if (this.isNaN || addend.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real + addend.getRealPart(), this.imaginary + addend.getImaginaryPart());
    }

    @Override
    public Complex add(double addend) {
        if (this.isNaN || Double.isNaN(addend)) {
            return NaN;
        }
        return this.createComplex(this.real + addend, this.imaginary);
    }

    public Complex conjugate() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real, -this.imaginary);
    }

    @Override
    public Complex divide(Complex divisor) throws NullArgumentException {
        MathUtils.checkNotNull(divisor);
        if (this.isNaN || divisor.isNaN) {
            return NaN;
        }
        double c = divisor.getRealPart();
        double d = divisor.getImaginaryPart();
        if (c == 0.0 && d == 0.0) {
            return NaN;
        }
        if (divisor.isInfinite() && !this.isInfinite()) {
            return ZERO;
        }
        if (FastMath.abs(c) < FastMath.abs(d)) {
            double q = c / d;
            double denominator = c * q + d;
            return this.createComplex((this.real * q + this.imaginary) / denominator, (this.imaginary * q - this.real) / denominator);
        }
        double q = d / c;
        double denominator = d * q + c;
        return this.createComplex((this.imaginary * q + this.real) / denominator, (this.imaginary - this.real * q) / denominator);
    }

    @Override
    public Complex divide(double divisor) {
        if (this.isNaN || Double.isNaN(divisor)) {
            return NaN;
        }
        if (divisor == 0.0) {
            return NaN;
        }
        if (Double.isInfinite(divisor)) {
            return !this.isInfinite() ? ZERO : NaN;
        }
        return this.createComplex(this.real / divisor, this.imaginary / divisor);
    }

    @Override
    public Complex reciprocal() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return INF;
        }
        if (this.isInfinite) {
            return ZERO;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            double q = this.real / this.imaginary;
            double scale = 1.0 / (this.real * q + this.imaginary);
            return this.createComplex(scale * q, -scale);
        }
        double q = this.imaginary / this.real;
        double scale = 1.0 / (this.imaginary * q + this.real);
        return this.createComplex(scale, -scale * q);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Complex) {
            Complex c = (Complex)other;
            if (c.isNaN) {
                return this.isNaN;
            }
            return MathUtils.equals(this.real, c.real) && MathUtils.equals(this.imaginary, c.imaginary);
        }
        return false;
    }

    public static boolean equals(Complex x, Complex y, int maxUlps) {
        return Precision.equals(x.real, y.real, maxUlps) && Precision.equals(x.imaginary, y.imaginary, maxUlps);
    }

    public static boolean equals(Complex x, Complex y) {
        return Complex.equals(x, y, 1);
    }

    public static boolean equals(Complex x, Complex y, double eps) {
        return Precision.equals(x.real, y.real, eps) && Precision.equals(x.imaginary, y.imaginary, eps);
    }

    public static boolean equalsWithRelativeTolerance(Complex x, Complex y, double eps) {
        return Precision.equalsWithRelativeTolerance(x.real, y.real, eps) && Precision.equalsWithRelativeTolerance(x.imaginary, y.imaginary, eps);
    }

    public int hashCode() {
        if (this.isNaN) {
            return 7;
        }
        return 37 * (17 * MathUtils.hash(this.imaginary) + MathUtils.hash(this.real));
    }

    @Override
    public boolean isZero() {
        return this.real == 0.0 && this.imaginary == 0.0;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double getImaginaryPart() {
        return this.imaginary;
    }

    @Override
    public double getReal() {
        return this.real;
    }

    public double getRealPart() {
        return this.real;
    }

    @Override
    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isReal() {
        return this.imaginary == 0.0;
    }

    public boolean isMathematicalInteger() {
        return this.isReal() && Precision.isMathematicalInteger(this.real);
    }

    @Override
    public boolean isInfinite() {
        return this.isInfinite;
    }

    @Override
    public Complex multiply(Complex factor) throws NullArgumentException {
        MathUtils.checkNotNull(factor);
        if (this.isNaN || factor.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(factor.real) || Double.isInfinite(factor.imaginary)) {
            return INF;
        }
        return this.createComplex(MathArrays.linearCombination(this.real, factor.real, -this.imaginary, factor.imaginary), MathArrays.linearCombination(this.real, factor.imaginary, this.imaginary, factor.real));
    }

    @Override
    public Complex multiply(int factor) {
        if (this.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary)) {
            return INF;
        }
        return this.createComplex(this.real * (double)factor, this.imaginary * (double)factor);
    }

    @Override
    public Complex multiply(double factor) {
        if (this.isNaN || Double.isNaN(factor)) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(factor)) {
            return INF;
        }
        return this.createComplex(this.real * factor, this.imaginary * factor);
    }

    public Complex multiplyPlusI() {
        return this.createComplex(-this.imaginary, this.real);
    }

    public Complex multiplyMinusI() {
        return this.createComplex(this.imaginary, -this.real);
    }

    @Override
    public Complex negate() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(-this.real, -this.imaginary);
    }

    @Override
    public Complex subtract(Complex subtrahend) throws NullArgumentException {
        MathUtils.checkNotNull(subtrahend);
        if (this.isNaN || subtrahend.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real - subtrahend.getRealPart(), this.imaginary - subtrahend.getImaginaryPart());
    }

    @Override
    public Complex subtract(double subtrahend) {
        if (this.isNaN || Double.isNaN(subtrahend)) {
            return NaN;
        }
        return this.createComplex(this.real - subtrahend, this.imaginary);
    }

    @Override
    public Complex acos() {
        if (this.isNaN) {
            return NaN;
        }
        return this.add(this.sqrt1z().multiplyPlusI()).log().multiplyMinusI();
    }

    @Override
    public Complex asin() {
        if (this.isNaN) {
            return NaN;
        }
        return this.sqrt1z().add(this.multiplyPlusI()).log().multiplyMinusI();
    }

    @Override
    public Complex atan() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0) {
            if (this.imaginary * this.imaginary - 1.0 == 0.0) {
                return NaN;
            }
            Complex tmp = this.createComplex((1.0 + this.imaginary) / (1.0 - this.imaginary), 0.0).log().multiplyPlusI().multiply(0.5);
            return this.createComplex(FastMath.copySign(tmp.real, this.real), tmp.imaginary);
        }
        Complex n = this.createComplex(1.0 + this.imaginary, -this.real);
        Complex d = this.createComplex(1.0 - this.imaginary, this.real);
        return n.divide(d).log().multiplyPlusI().multiply(0.5);
    }

    @Override
    public Complex cos() {
        if (this.isNaN) {
            return NaN;
        }
        SinCos scr = FastMath.sinCos(this.real);
        SinhCosh schi = FastMath.sinhCosh(this.imaginary);
        return this.createComplex(scr.cos() * schi.cosh(), -scr.sin() * schi.sinh());
    }

    @Override
    public Complex cosh() {
        if (this.isNaN) {
            return NaN;
        }
        SinhCosh schr = FastMath.sinhCosh(this.real);
        SinCos sci = FastMath.sinCos(this.imaginary);
        return this.createComplex(schr.cosh() * sci.cos(), schr.sinh() * sci.sin());
    }

    @Override
    public Complex exp() {
        if (this.isNaN) {
            return NaN;
        }
        double expReal = FastMath.exp(this.real);
        SinCos sc = FastMath.sinCos(this.imaginary);
        return this.createComplex(expReal * sc.cos(), expReal * sc.sin());
    }

    @Override
    public Complex expm1() {
        if (this.isNaN) {
            return NaN;
        }
        double expm1Real = FastMath.expm1(this.real);
        SinCos sc = FastMath.sinCos(this.imaginary);
        return this.createComplex(expm1Real * sc.cos(), expm1Real * sc.sin());
    }

    @Override
    public Complex log() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.log(FastMath.hypot(this.real, this.imaginary)), FastMath.atan2(this.imaginary, this.real));
    }

    @Override
    public Complex log1p() {
        return this.add(1.0).log();
    }

    @Override
    public Complex log10() {
        return this.log().divide(2.302585092994046);
    }

    @Override
    public Complex pow(Complex x) throws NullArgumentException {
        MathUtils.checkNotNull(x);
        if (x.imaginary == 0.0) {
            double realPow;
            int nx = (int)FastMath.rint(x.real);
            if (x.real == (double)nx) {
                return this.pow(nx);
            }
            if (this.imaginary == 0.0 && Double.isFinite(realPow = FastMath.pow(this.real, x.real))) {
                return this.createComplex(realPow, 0.0);
            }
        }
        return this.log().multiply(x).exp();
    }

    @Override
    public Complex pow(double x) {
        double realPow;
        int nx = (int)FastMath.rint(x);
        if (x == (double)nx) {
            return this.pow(nx);
        }
        if (this.imaginary == 0.0 && Double.isFinite(realPow = FastMath.pow(this.real, x))) {
            return this.createComplex(realPow, 0.0);
        }
        return this.log().multiply(x).exp();
    }

    @Override
    public Complex pow(int n) {
        boolean invert;
        Complex result = ONE;
        int p = n;
        if (p < 0) {
            invert = true;
            p = -p;
        } else {
            invert = false;
        }
        Complex square = this;
        while (p > 0) {
            if ((p & 1) > 0) {
                result = result.multiply(square);
            }
            square = square.multiply(square);
            p >>= 1;
        }
        return invert ? result.reciprocal() : result;
    }

    @Override
    public Complex sin() {
        if (this.isNaN) {
            return NaN;
        }
        SinCos scr = FastMath.sinCos(this.real);
        SinhCosh schi = FastMath.sinhCosh(this.imaginary);
        return this.createComplex(scr.sin() * schi.cosh(), scr.cos() * schi.sinh());
    }

    @Override
    public FieldSinCos<Complex> sinCos() {
        if (this.isNaN) {
            return new FieldSinCos<Complex>(NaN, NaN);
        }
        SinCos scr = FastMath.sinCos(this.real);
        SinhCosh schi = FastMath.sinhCosh(this.imaginary);
        return new FieldSinCos<Complex>(this.createComplex(scr.sin() * schi.cosh(), scr.cos() * schi.sinh()), this.createComplex(scr.cos() * schi.cosh(), -scr.sin() * schi.sinh()));
    }

    @Override
    public Complex atan2(Complex x) {
        Complex r = x.multiply(x).add(this.multiply(this)).sqrt();
        if (FastMath.copySign(1.0, x.real) >= 0.0) {
            return this.divide(r.add(x)).atan().multiply(2);
        }
        return this.divide(r.subtract(x)).atan().multiply(-2).add(Math.PI);
    }

    @Override
    public Complex acosh() {
        Complex sqrtPlus = this.add(1.0).sqrt();
        Complex sqrtMinus = this.subtract(1.0).sqrt();
        return this.add(sqrtPlus.multiply(sqrtMinus)).log();
    }

    @Override
    public Complex asinh() {
        return this.add(this.multiply(this).add(1.0).sqrt()).log();
    }

    @Override
    public Complex atanh() {
        Complex logPlus = this.add(1.0).log();
        Complex logMinus = this.createComplex(1.0 - this.real, -this.imaginary).log();
        return logPlus.subtract(logMinus).multiply(0.5);
    }

    @Override
    public Complex sinh() {
        if (this.isNaN) {
            return NaN;
        }
        SinhCosh schr = FastMath.sinhCosh(this.real);
        SinCos sci = FastMath.sinCos(this.imaginary);
        return this.createComplex(schr.sinh() * sci.cos(), schr.cosh() * sci.sin());
    }

    @Override
    public FieldSinhCosh<Complex> sinhCosh() {
        if (this.isNaN) {
            return new FieldSinhCosh<Complex>(NaN, NaN);
        }
        SinhCosh schr = FastMath.sinhCosh(this.real);
        SinCos sci = FastMath.sinCos(this.imaginary);
        return new FieldSinhCosh<Complex>(this.createComplex(schr.sinh() * sci.cos(), schr.cosh() * sci.sin()), this.createComplex(schr.cosh() * sci.cos(), schr.sinh() * sci.sin()));
    }

    @Override
    public Complex sqrt() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        double t = FastMath.sqrt((FastMath.abs(this.real) + FastMath.hypot(this.real, this.imaginary)) * 0.5);
        if (FastMath.copySign(1.0, this.real) >= 0.0) {
            return this.createComplex(t, this.imaginary / (2.0 * t));
        }
        return this.createComplex(FastMath.abs(this.imaginary) / (2.0 * t), FastMath.copySign(t, this.imaginary));
    }

    public Complex sqrt1z() {
        Complex t2 = this.multiply(this);
        return this.createComplex(1.0 - t2.real, -t2.imaginary).sqrt();
    }

    @Override
    public Complex cbrt() {
        double magnitude = FastMath.cbrt(this.norm());
        SinCos sc = FastMath.sinCos(this.getArgument() / 3.0);
        return this.createComplex(magnitude * sc.cos(), magnitude * sc.sin());
    }

    @Override
    public Complex rootN(int n) {
        double magnitude = FastMath.pow(this.norm(), 1.0 / (double)n);
        SinCos sc = FastMath.sinCos(this.getArgument() / (double)n);
        return this.createComplex(magnitude * sc.cos(), magnitude * sc.sin());
    }

    @Override
    public Complex tan() {
        if (this.isNaN || Double.isInfinite(this.real)) {
            return NaN;
        }
        if (this.imaginary > 20.0) {
            return I;
        }
        if (this.imaginary < -20.0) {
            return MINUS_I;
        }
        SinCos sc2r = FastMath.sinCos(2.0 * this.real);
        double imaginary2 = 2.0 * this.imaginary;
        double d = sc2r.cos() + FastMath.cosh(imaginary2);
        return this.createComplex(sc2r.sin() / d, FastMath.sinh(imaginary2) / d);
    }

    @Override
    public Complex tanh() {
        if (this.isNaN || Double.isInfinite(this.imaginary)) {
            return NaN;
        }
        if (this.real > 20.0) {
            return ONE;
        }
        if (this.real < -20.0) {
            return MINUS_ONE;
        }
        double real2 = 2.0 * this.real;
        SinCos sc2i = FastMath.sinCos(2.0 * this.imaginary);
        double d = FastMath.cosh(real2) + sc2i.cos();
        return this.createComplex(FastMath.sinh(real2) / d, sc2i.sin() / d);
    }

    public double getArgument() {
        return FastMath.atan2(this.getImaginaryPart(), this.getRealPart());
    }

    public List<Complex> nthRoot(int n) throws MathIllegalArgumentException {
        if (n <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, n);
        }
        ArrayList<Complex> result = new ArrayList<Complex>();
        if (this.isNaN) {
            result.add(NaN);
            return result;
        }
        if (this.isInfinite()) {
            result.add(INF);
            return result;
        }
        double nthRootOfAbs = FastMath.pow(FastMath.hypot(this.real, this.imaginary), 1.0 / (double)n);
        double nthPhi = this.getArgument() / (double)n;
        double slice = Math.PI * 2 / (double)n;
        double innerPart = nthPhi;
        for (int k = 0; k < n; ++k) {
            SinCos scInner = FastMath.sinCos(innerPart);
            double realPart = nthRootOfAbs * scInner.cos();
            double imaginaryPart = nthRootOfAbs * scInner.sin();
            result.add(this.createComplex(realPart, imaginaryPart));
            innerPart += slice;
        }
        return result;
    }

    protected Complex createComplex(double realPart, double imaginaryPart) {
        return new Complex(realPart, imaginaryPart);
    }

    public static Complex valueOf(double realPart, double imaginaryPart) {
        if (Double.isNaN(realPart) || Double.isNaN(imaginaryPart)) {
            return NaN;
        }
        return new Complex(realPart, imaginaryPart);
    }

    public static Complex valueOf(double realPart) {
        if (Double.isNaN(realPart)) {
            return NaN;
        }
        return new Complex(realPart);
    }

    @Override
    public Complex newInstance(double realPart) {
        return Complex.valueOf(realPart);
    }

    protected final Object readResolve() {
        return this.createComplex(this.real, this.imaginary);
    }

    public ComplexField getField() {
        return ComplexField.getInstance();
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ")";
    }

    @Override
    public Complex scalb(int n) {
        return this.createComplex(FastMath.scalb(this.real, n), FastMath.scalb(this.imaginary, n));
    }

    @Override
    public Complex ulp() {
        return this.createComplex(FastMath.ulp(this.real), FastMath.ulp(this.imaginary));
    }

    @Override
    public Complex hypot(Complex y) {
        if (this.isInfinite() || y.isInfinite()) {
            return INF;
        }
        if (this.isNaN() || y.isNaN()) {
            return NaN;
        }
        return this.multiply(this).add(y.multiply(y)).sqrt();
    }

    public Complex linearCombination(Complex[] a, Complex[] b) throws MathIllegalArgumentException {
        int n = 2 * a.length;
        double[] realA = new double[n];
        double[] realB = new double[n];
        double[] imaginaryA = new double[n];
        double[] imaginaryB = new double[n];
        for (int i = 0; i < a.length; ++i) {
            Complex ai = a[i];
            Complex bi = b[i];
            realA[2 * i] = ai.real;
            realA[2 * i + 1] = -ai.imaginary;
            realB[2 * i] = bi.real;
            realB[2 * i + 1] = bi.imaginary;
            imaginaryA[2 * i] = ai.real;
            imaginaryA[2 * i + 1] = ai.imaginary;
            imaginaryB[2 * i] = bi.imaginary;
            imaginaryB[2 * i + 1] = bi.real;
        }
        return this.createComplex(MathArrays.linearCombination(realA, realB), MathArrays.linearCombination(imaginaryA, imaginaryB));
    }

    public Complex linearCombination(double[] a, Complex[] b) throws MathIllegalArgumentException {
        int n = a.length;
        double[] realB = new double[n];
        double[] imaginaryB = new double[n];
        for (int i = 0; i < a.length; ++i) {
            Complex bi = b[i];
            realB[i] = bi.real;
            imaginaryB[i] = bi.imaginary;
        }
        return this.createComplex(MathArrays.linearCombination(a, realB), MathArrays.linearCombination(a, imaginaryB));
    }

    @Override
    public Complex linearCombination(Complex a1, Complex b1, Complex a2, Complex b2) {
        return this.createComplex(MathArrays.linearCombination(a1.real, b1.real, -a1.imaginary, b1.imaginary, a2.real, b2.real, -a2.imaginary, b2.imaginary), MathArrays.linearCombination(a1.real, b1.imaginary, a1.imaginary, b1.real, a2.real, b2.imaginary, a2.imaginary, b2.real));
    }

    @Override
    public Complex linearCombination(double a1, Complex b1, double a2, Complex b2) {
        return this.createComplex(MathArrays.linearCombination(a1, b1.real, a2, b2.real), MathArrays.linearCombination(a1, b1.imaginary, a2, b2.imaginary));
    }

    @Override
    public Complex linearCombination(Complex a1, Complex b1, Complex a2, Complex b2, Complex a3, Complex b3) {
        return this.linearCombination(new Complex[]{a1, a2, a3}, new Complex[]{b1, b2, b3});
    }

    @Override
    public Complex linearCombination(double a1, Complex b1, double a2, Complex b2, double a3, Complex b3) {
        return this.linearCombination(new double[]{a1, a2, a3}, new Complex[]{b1, b2, b3});
    }

    @Override
    public Complex linearCombination(Complex a1, Complex b1, Complex a2, Complex b2, Complex a3, Complex b3, Complex a4, Complex b4) {
        return this.linearCombination(new Complex[]{a1, a2, a3, a4}, new Complex[]{b1, b2, b3, b4});
    }

    @Override
    public Complex linearCombination(double a1, Complex b1, double a2, Complex b2, double a3, Complex b3, double a4, Complex b4) {
        return this.linearCombination(new double[]{a1, a2, a3, a4}, new Complex[]{b1, b2, b3, b4});
    }

    @Override
    public Complex getPi() {
        return PI;
    }

    @Override
    public Complex ceil() {
        return this.createComplex(FastMath.ceil(this.getRealPart()), FastMath.ceil(this.getImaginaryPart()));
    }

    @Override
    public Complex floor() {
        return this.createComplex(FastMath.floor(this.getRealPart()), FastMath.floor(this.getImaginaryPart()));
    }

    @Override
    public Complex rint() {
        return this.createComplex(FastMath.rint(this.getRealPart()), FastMath.rint(this.getImaginaryPart()));
    }

    @Override
    public Complex remainder(double a) {
        return this.createComplex(FastMath.IEEEremainder(this.getRealPart(), a), FastMath.IEEEremainder(this.getImaginaryPart(), a));
    }

    @Override
    public Complex remainder(Complex a) {
        Complex complexQuotient = this.divide(a);
        double qRInt = FastMath.rint(complexQuotient.real);
        double qIInt = FastMath.rint(complexQuotient.imaginary);
        return this.createComplex(this.real - qRInt * a.real + qIInt * a.imaginary, this.imaginary - qRInt * a.imaginary - qIInt * a.real);
    }

    @Override
    public Complex sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return this.divide(FastMath.hypot(this.real, this.imaginary));
    }

    @Override
    public Complex copySign(Complex z) {
        return this.createComplex(FastMath.copySign(this.getRealPart(), z.getRealPart()), FastMath.copySign(this.getImaginaryPart(), z.getImaginaryPart()));
    }

    @Override
    public Complex copySign(double r) {
        return this.createComplex(FastMath.copySign(this.getRealPart(), r), FastMath.copySign(this.getImaginaryPart(), r));
    }

    @Override
    public Complex toDegrees() {
        return this.createComplex(FastMath.toDegrees(this.getRealPart()), FastMath.toDegrees(this.getImaginaryPart()));
    }

    @Override
    public Complex toRadians() {
        return this.createComplex(FastMath.toRadians(this.getRealPart()), FastMath.toRadians(this.getImaginaryPart()));
    }
}

