/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class S1Point
implements Point<Sphere1D> {
    public static final S1Point NaN = new S1Point(Double.NaN, Vector2D.NaN);
    private static final long serialVersionUID = 20131218L;
    private final double alpha;
    private final Vector2D vector;

    public S1Point(double alpha) {
        this(MathUtils.normalizeAngle((double)alpha, (double)Math.PI), S1Point.buildVector(alpha));
    }

    private S1Point(double alpha, Vector2D vector) {
        this.alpha = alpha;
        this.vector = vector;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public Vector2D getVector() {
        return this.vector;
    }

    @Override
    public Space getSpace() {
        return Sphere1D.getInstance();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.alpha);
    }

    @Override
    public double distance(Point<Sphere1D> point) {
        return S1Point.distance(this, (S1Point)point);
    }

    public static double distance(S1Point p1, S1Point p2) {
        return Vector2D.angle(p1.vector, p2.vector);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof S1Point) {
            S1Point rhs = (S1Point)other;
            return this.alpha == rhs.alpha || this.isNaN() && rhs.isNaN();
        }
        return false;
    }

    public boolean equalsIeee754(Object other) {
        if (this == other && !this.isNaN()) {
            return true;
        }
        if (other instanceof S1Point) {
            S1Point rhs = (S1Point)other;
            return this.alpha == rhs.alpha;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 1759 * MathUtils.hash((double)this.alpha);
    }

    private static Vector2D buildVector(double alpha) {
        SinCos sc = FastMath.sinCos((double)alpha);
        return new Vector2D(sc.cos(), sc.sin());
    }
}

