import java.io
import java.lang
import java.text
import java.util
import org.hipparchus.exception
import typing



class LocalizedException:
    """
    public interface LocalizedException
    
        This interface specified methods implemented by localized exception classes.
    
        Since:
            7.1
    """
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class OrekitMessages(java.lang.Enum['OrekitMessages'], org.hipparchus.exception.Localizable):
    """
    public enum OrekitMessages extends Enum<:class:`~org.orekit.errors.OrekitMessages`> implements Localizable
    
        Enumeration for localized messages formats.
    
        The constants in this enumeration represent the available formats as localized strings. These formats are intended to be
        localized using simple properties files, using the constant name as the key and the property value as the message
        format. The source English format is provided in the constants themselves to serve both as a reminder for developers to
        understand the parameters needed by each format, as a basis for translators to create localized properties files, and as
        a default format if some translation is missing.
    
        Since:
            2.1
    """
    INTERNAL_ERROR: typing.ClassVar['OrekitMessages'] = ...
    ALTITUDE_BELOW_ALLOWED_THRESHOLD: typing.ClassVar['OrekitMessages'] = ...
    POINT_INSIDE_ELLIPSOID: typing.ClassVar['OrekitMessages'] = ...
    TRAJECTORY_INSIDE_BRILLOUIN_SPHERE: typing.ClassVar['OrekitMessages'] = ...
    ALMOST_EQUATORIAL_ORBIT: typing.ClassVar['OrekitMessages'] = ...
    ALMOST_CRITICALLY_INCLINED_ORBIT: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_COMPUTE_ECKSTEIN_HECHLER_MEAN_PARAMETERS: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_COMPUTE_BROUWER_LYDDANE_MEAN_PARAMETERS: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_COMPUTE_TLE: typing.ClassVar['OrekitMessages'] = ...
    NULL_PARENT_FOR_FRAME: typing.ClassVar['OrekitMessages'] = ...
    FRAME_ALREADY_ATTACHED: typing.ClassVar['OrekitMessages'] = ...
    FRAME_NOT_ATTACHED: typing.ClassVar['OrekitMessages'] = ...
    FRAME_ANCESTOR_OF_BOTH_FRAMES: typing.ClassVar['OrekitMessages'] = ...
    FRAME_ANCESTOR_OF_NEITHER_FRAME: typing.ClassVar['OrekitMessages'] = ...
    FRAME_NO_NTH_ANCESTOR: typing.ClassVar['OrekitMessages'] = ...
    NO_SUCH_ITRF_FRAME: typing.ClassVar['OrekitMessages'] = ...
    UNSUPPORTED_LOCAL_ORBITAL_FRAME: typing.ClassVar['OrekitMessages'] = ...
    NON_PSEUDO_INERTIAL_FRAME: typing.ClassVar['OrekitMessages'] = ...
    DATA_ROOT_DIRECTORY_DOES_NOT_EXIST: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_DIRECTORY: typing.ClassVar['OrekitMessages'] = ...
    NEITHER_DIRECTORY_NOR_ZIP_OR_JAR: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_FIND_RESOURCE: typing.ClassVar['OrekitMessages'] = ...
    NO_EARTH_ORIENTATION_PARAMETERS_LOADED: typing.ClassVar['OrekitMessages'] = ...
    MISSING_EARTH_ORIENTATION_PARAMETERS_BETWEEN_DATES: typing.ClassVar['OrekitMessages'] = ...
    MISSING_EARTH_ORIENTATION_PARAMETERS_BETWEEN_DATES_GAP: typing.ClassVar['OrekitMessages'] = ...
    NO_EARTH_ORIENTATION_PARAMETERS: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_SUPPORTED_IERS_DATA_FILE: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_DATES_IN_IERS_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_DATA_AFTER_LINE_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_DATA_AT_LINE_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    NON_CHRONOLOGICAL_DATES_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    NO_IERS_UTC_TAI_HISTORY_DATA_LOADED: typing.ClassVar['OrekitMessages'] = ...
    NO_ENTRIES_IN_IERS_UTC_TAI_HISTORY_FILE: typing.ClassVar['OrekitMessages'] = ...
    MISSING_SERIE_J_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_PARSE_BOTH_TAU_AND_GAMMA: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_END_OF_FILE_AFTER_LINE: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_PARSE_LINE_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_PARSE_ELEMENT_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_FIND_FILE: typing.ClassVar['OrekitMessages'] = ...
    SPACECRAFT_MASS_BECOMES_NEGATIVE: typing.ClassVar['OrekitMessages'] = ...
    POSITIVE_FLOW_RATE: typing.ClassVar['OrekitMessages'] = ...
    NO_GRAVITY_FIELD_DATA_LOADED: typing.ClassVar['OrekitMessages'] = ...
    GRAVITY_FIELD_NORMALIZATION_UNDERFLOW: typing.ClassVar['OrekitMessages'] = ...
    NO_OCEAN_TIDE_DATA_LOADED: typing.ClassVar['OrekitMessages'] = ...
    OCEAN_TIDE_DATA_DEGREE_ORDER_LIMITS: typing.ClassVar['OrekitMessages'] = ...
    OCEAN_TIDE_LOAD_DEFORMATION_LIMITS: typing.ClassVar['OrekitMessages'] = ...
    POLAR_TRAJECTORY: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER: typing.ClassVar['OrekitMessages'] = ...
    DUPLICATED_GRAVITY_FIELD_COEFFICIENT_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    MISSING_GRAVITY_FIELD_COEFFICIENT_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    TOO_LARGE_DEGREE_FOR_GRAVITY_FIELD: typing.ClassVar['OrekitMessages'] = ...
    TOO_LARGE_ORDER_FOR_GRAVITY_FIELD: typing.ClassVar['OrekitMessages'] = ...
    WRONG_DEGREE_OR_ORDER: typing.ClassVar['OrekitMessages'] = ...
    SEVERAL_REFERENCE_DATES_IN_GRAVITY_FIELD: typing.ClassVar['OrekitMessages'] = ...
    NO_TLE_FOR_OBJECT: typing.ClassVar['OrekitMessages'] = ...
    NO_TLE_FOR_LAUNCH_YEAR_NUMBER_PIECE: typing.ClassVar['OrekitMessages'] = ...
    NOT_TLE_LINES: typing.ClassVar['OrekitMessages'] = ...
    MISSING_SECOND_TLE_LINE: typing.ClassVar['OrekitMessages'] = ...
    TLE_LINES_DO_NOT_REFER_TO_SAME_OBJECT: typing.ClassVar['OrekitMessages'] = ...
    TLE_INVALID_PARAMETER: typing.ClassVar['OrekitMessages'] = ...
    TLE_CHECKSUM_ERROR: typing.ClassVar['OrekitMessages'] = ...
    NO_TLE_DATA_AVAILABLE: typing.ClassVar['OrekitMessages'] = ...
    NOT_POSITIVE_SPACECRAFT_MASS: typing.ClassVar['OrekitMessages'] = ...
    TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL: typing.ClassVar['OrekitMessages'] = ...
    NO_SOLAR_ACTIVITY_AT_DATE: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_MONTH: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_YEAR_MONTH_DAY: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_WEEK_DATE: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_DATE: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_DAY_NUMBER_IN_YEAR: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_HMS_TIME: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_TIME: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_SECONDS_NUMBER: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_SECONDS_NUMBER_DETAIL: typing.ClassVar['OrekitMessages'] = ...
    ANGLE_TYPE_NOT_SUPPORTED: typing.ClassVar['OrekitMessages'] = ...
    SATELLITE_COLLIDED_WITH_TARGET: typing.ClassVar['OrekitMessages'] = ...
    ATTITUDE_POINTING_LAW_DOES_NOT_POINT_TO_GROUND: typing.ClassVar['OrekitMessages'] = ...
    TOO_SHORT_TRANSITION_TIME_FOR_ATTITUDES_SWITCH: typing.ClassVar['OrekitMessages'] = ...
    ORBIT_AND_ATTITUDE_DATES_MISMATCH: typing.ClassVar['OrekitMessages'] = ...
    FRAMES_MISMATCH: typing.ClassVar['OrekitMessages'] = ...
    INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION: typing.ClassVar['OrekitMessages'] = ...
    EVENT_DATE_TOO_CLOSE: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_READ_JPL_HEADER: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_ASTRONOMICAL_UNIT_IN_FILES: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_EARTH_MOON_RATIO_IN_FILES: typing.ClassVar['OrekitMessages'] = ...
    NO_DATA_LOADED_FOR_CELESTIAL_BODY: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_JPL_EPHEMERIDES_BINARY_FILE: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE: typing.ClassVar['OrekitMessages'] = ...
    NO_JPL_EPHEMERIDES_BINARY_FILES_FOUND: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_BODY_EPHEMERIDES_DATE: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_EPHEMERIDES_DATE: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_TWO_ELEVATION_VALUES_FOR_ONE_AZIMUTH: typing.ClassVar['OrekitMessages'] = ...
    UNSUPPORTED_PARAMETER_NAME: typing.ClassVar['OrekitMessages'] = ...
    TOO_SMALL_SCALE_FOR_PARAMETER: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_ADDITIONAL_STATE: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_MONTH: typing.ClassVar['OrekitMessages'] = ...
    SINGULAR_JACOBIAN_FOR_ORBIT_TYPE: typing.ClassVar['OrekitMessages'] = ...
    STATE_JACOBIAN_NOT_INITIALIZED: typing.ClassVar['OrekitMessages'] = ...
    STATE_JACOBIAN_NOT_6X6: typing.ClassVar['OrekitMessages'] = ...
    STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH: typing.ClassVar['OrekitMessages'] = ...
    INITIAL_MATRIX_AND_PARAMETERS_NUMBER_MISMATCH: typing.ClassVar['OrekitMessages'] = ...
    ORBIT_A_E_MISMATCH_WITH_CONIC_TYPE: typing.ClassVar['OrekitMessages'] = ...
    ORBIT_ANOMALY_OUT_OF_HYPERBOLIC_RANGE: typing.ClassVar['OrekitMessages'] = ...
    HYPERBOLIC_ORBIT_NOT_HANDLED_AS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_DATE_INVALID_PREAMBLE_FIELD: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_DATE_INVALID_LENGTH_TIME_FIELD: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_DATE_MISSING_AGENCY_EPOCH: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_MISSING_KEYWORD: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_KEYWORD_NOT_ALLOWED_IN_VERSION: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNEXPECTED_KEYWORD: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNKNOWN_GM: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNKNOWN_SPACECRAFT_MASS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNKNOWN_CONVENTIONS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_INVALID_FRAME: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_INCONSISTENT_TIME_SYSTEMS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_TDM_KEYWORD_NOT_FOUND: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_TDM_MISSING_RANGE_UNITS_CONVERTER: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_TIME_SYSTEM_NOT_READ_YET: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_AEM_INCONSISTENT_TIME_SYSTEMS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_INVALID_ROTATION_SEQUENCE: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNSUPPORTED_ELEMENT_SET_TYPE: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_UNSUPPORTED_RETROGRADE_EQUINOCTIAL: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_ELEMENT_SET_WRONG_NB_COMPONENTS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_MANEUVER_UNITS_WRONG_NB_COMPONENTS: typing.ClassVar['OrekitMessages'] = ...
    CCSDS_MANEUVER_MISSING_TIME: typing.ClassVar['OrekitMessages'] = ...
    ADDITIONAL_STATE_NAME_ALREADY_IN_USE: typing.ClassVar['OrekitMessages'] = ...
    NON_RESETABLE_STATE: typing.ClassVar['OrekitMessages'] = ...
    DSST_NEWCOMB_OPERATORS_COMPUTATION: typing.ClassVar['OrekitMessages'] = ...
    DSST_VMNS_COEFFICIENT_ERROR_MS: typing.ClassVar['OrekitMessages'] = ...
    DSST_SPR_SHADOW_INCONSISTENT: typing.ClassVar['OrekitMessages'] = ...
    DSST_ECC_NO_NUMERICAL_AVERAGING_METHOD: typing.ClassVar['OrekitMessages'] = ...
    SP3_UNSUPPORTED_VERSION: typing.ClassVar['OrekitMessages'] = ...
    SP3_NUMBER_OF_EPOCH_MISMATCH: typing.ClassVar['OrekitMessages'] = ...
    SP3_UNEXPECTED_END_OF_FILE: typing.ClassVar['OrekitMessages'] = ...
    CLOCK_FILE_UNSUPPORTED_VERSION: typing.ClassVar['OrekitMessages'] = ...
    NAVIGATION_FILE_UNSUPPORTED_VERSION: typing.ClassVar['OrekitMessages'] = ...
    NON_EXISTENT_GEOMAGNETIC_MODEL: typing.ClassVar['OrekitMessages'] = ...
    UNSUPPORTED_TIME_TRANSFORM: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_TIME_TRANSFORM: typing.ClassVar['OrekitMessages'] = ...
    NOT_ENOUGH_DATA_FOR_INTERPOLATION: typing.ClassVar['OrekitMessages'] = ...
    NOT_ENOUGH_CACHED_NEIGHBORS: typing.ClassVar['OrekitMessages'] = ...
    NO_CACHED_ENTRIES: typing.ClassVar['OrekitMessages'] = ...
    NON_CHRONOLOGICALLY_SORTED_ENTRIES: typing.ClassVar['OrekitMessages'] = ...
    NO_DATA_GENERATED: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_GENERATE_NEW_DATA_BEFORE: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_GENERATE_NEW_DATA_AFTER: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY: typing.ClassVar['OrekitMessages'] = ...
    UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS: typing.ClassVar['OrekitMessages'] = ...
    OUT_OF_RANGE_DERIVATION_ORDER: typing.ClassVar['OrekitMessages'] = ...
    ORBIT_TYPE_NOT_ALLOWED: typing.ClassVar['OrekitMessages'] = ...
    NON_PSEUDO_INERTIAL_FRAME_NOT_SUITABLE_AS_REFERENCE_FOR_INERTIAL_FORCES: typing.ClassVar['OrekitMessages'] = ...
    METHOD_NOT_AVAILABLE_WITHOUT_CENTRAL_BODY: typing.ClassVar['OrekitMessages'] = ...
    INCOMPATIBLE_FRAMES: typing.ClassVar['OrekitMessages'] = ...
    UNDEFINED_ORBIT: typing.ClassVar['OrekitMessages'] = ...
    UNDEFINED_ABSOLUTE_PVCOORDINATES: typing.ClassVar['OrekitMessages'] = ...
    INERTIAL_FORCE_MODEL_MISSING: typing.ClassVar['OrekitMessages'] = ...
    NO_SEM_ALMANAC_AVAILABLE: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_SUPPORTED_SEM_ALMANAC_FILE: typing.ClassVar['OrekitMessages'] = ...
    NO_YUMA_ALMANAC_AVAILABLE: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_SUPPORTED_YUMA_ALMANAC_FILE: typing.ClassVar['OrekitMessages'] = ...
    NOT_ENOUGH_GNSS_FOR_DOP: typing.ClassVar['OrekitMessages'] = ...
    NOT_ENOUGH_PROPAGATORS: typing.ClassVar['OrekitMessages'] = ...
    NOT_ENOUGH_ATTITUDE_PROVIDERS: typing.ClassVar['OrekitMessages'] = ...
    NULL_ARGUMENT: typing.ClassVar['OrekitMessages'] = ...
    VALUE_NOT_FOUND: typing.ClassVar['OrekitMessages'] = ...
    KLOBUCHAR_ALPHA_BETA_NOT_LOADED: typing.ClassVar['OrekitMessages'] = ...
    KLOBUCHAR_ALPHA_BETA_NOT_AVAILABLE_FOR_DATE: typing.ClassVar['OrekitMessages'] = ...
    NO_KLOBUCHAR_ALPHA_BETA_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    NO_REFERENCE_DATE_FOR_PARAMETER: typing.ClassVar['OrekitMessages'] = ...
    STATION_NOT_FOUND: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_SATELLITE_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_TIME_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_CLOCK_DATA_TYPE: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_SATELLITE_ANTENNA_CODE: typing.ClassVar['OrekitMessages'] = ...
    UNSUPPORTED_FREQUENCY_FOR_ANTENNA: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_FIND_SATELLITE_IN_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_RINEX_FREQUENCY: typing.ClassVar['OrekitMessages'] = ...
    MISMATCHED_FREQUENCIES: typing.ClassVar['OrekitMessages'] = ...
    WRONG_COLUMNS_NUMBER: typing.ClassVar['OrekitMessages'] = ...
    UNSUPPORTED_FILE_FORMAT: typing.ClassVar['OrekitMessages'] = ...
    INCOMPLETE_HEADER: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_NUMBER_OF_SATS: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_SATELLITE_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    NO_PROPAGATOR_CONFIGURED: typing.ClassVar['OrekitMessages'] = ...
    DIMENSION_INCONSISTENT_WITH_PARAMETERS: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_SUPPORTED_UNIX_COMPRESSED_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_END_OF_FILE: typing.ClassVar['OrekitMessages'] = ...
    CORRUPTED_FILE: typing.ClassVar['OrekitMessages'] = ...
    VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_LOADED: typing.ClassVar['OrekitMessages'] = ...
    VIENNA_ACOEF_OR_ZENITH_DELAY_NOT_AVAILABLE_FOR_DATE: typing.ClassVar['OrekitMessages'] = ...
    NO_VIENNA_ACOEF_OR_ZENITH_DELAY_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    IRREGULAR_OR_INCOMPLETE_GRID: typing.ClassVar['OrekitMessages'] = ...
    INVALID_SATELLITE_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    NO_TEC_DATA_IN_FILE_FOR_DATE: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_NUMBER_OF_TEC_MAPS_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    NO_LATITUDE_LONGITUDE_BONDARIES_IN_IONEX_HEADER: typing.ClassVar['OrekitMessages'] = ...
    NO_EPOCH_IN_IONEX_HEADER: typing.ClassVar['OrekitMessages'] = ...
    ITRF_VERSIONS_PREFIX_ONLY: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_COMPUTE_AIMING_AT_SINGULAR_POINT: typing.ClassVar['OrekitMessages'] = ...
    STEC_INTEGRATION_DID_NOT_CONVERGE: typing.ClassVar['OrekitMessages'] = ...
    MODIP_GRID_NOT_LOADED: typing.ClassVar['OrekitMessages'] = ...
    NEQUICK_F2_FM3_NOT_LOADED: typing.ClassVar['OrekitMessages'] = ...
    NOT_A_SUPPORTED_HATANAKA_COMPRESSED_FILE: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_COMPUTE_LAGRANGIAN: typing.ClassVar['OrekitMessages'] = ...
    TRAJECTORY_NOT_CROSSING_XZPLANE: typing.ClassVar['OrekitMessages'] = ...
    MULTIPLE_SHOOTING_UNDERCONSTRAINED: typing.ClassVar['OrekitMessages'] = ...
    INVALID_MEASUREMENT_TYPES_FOR_COMBINATION_OF_MEASUREMENTS: typing.ClassVar['OrekitMessages'] = ...
    INCOMPATIBLE_FREQUENCIES_FOR_COMBINATION_OF_MEASUREMENTS: typing.ClassVar['OrekitMessages'] = ...
    NON_CHRONOLOGICAL_DATES_FOR_OBSERVATIONS: typing.ClassVar['OrekitMessages'] = ...
    EXCEPTIONAL_DATA_CONTEXT: typing.ClassVar['OrekitMessages'] = ...
    NON_DIFFERENT_DATES_FOR_OBSERVATIONS: typing.ClassVar['OrekitMessages'] = ...
    NON_COPLANAR_POINTS: typing.ClassVar['OrekitMessages'] = ...
    INVALID_PARAMETER_RANGE: typing.ClassVar['OrekitMessages'] = ...
    PARAMETER_NOT_SET: typing.ClassVar['OrekitMessages'] = ...
    FUNCTION_NOT_IMPLEMENTED: typing.ClassVar['OrekitMessages'] = ...
    INVALID_TYPE_FOR_FUNCTION: typing.ClassVar['OrekitMessages'] = ...
    NO_DATA_IN_FILE: typing.ClassVar['OrekitMessages'] = ...
    CPF_UNEXPECTED_END_OF_FILE: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_FORMAT_FOR_ILRS_FILE: typing.ClassVar['OrekitMessages'] = ...
    CRD_UNEXPECTED_END_OF_FILE: typing.ClassVar['OrekitMessages'] = ...
    INVALID_RANGE_INDICATOR_IN_CRD_FILE: typing.ClassVar['OrekitMessages'] = ...
    END_OF_ENCODED_MESSAGE: typing.ClassVar['OrekitMessages'] = ...
    TOO_LARGE_DATA_TYPE: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_ENCODED_MESSAGE_NUMBER: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_AUTHENTICATION_METHOD: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_CARRIER_PHASE_CODE: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_DATA_FORMAT: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_NAVIGATION_SYSTEM: typing.ClassVar['OrekitMessages'] = ...
    STREAM_REQUIRES_NMEA_FIX: typing.ClassVar['OrekitMessages'] = ...
    FAILED_AUTHENTICATION: typing.ClassVar['OrekitMessages'] = ...
    CONNECTION_ERROR: typing.ClassVar['OrekitMessages'] = ...
    UNEXPECTED_CONTENT_TYPE: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_PARSE_GNSS_DATA: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_HOST: typing.ClassVar['OrekitMessages'] = ...
    SOURCETABLE_PARSE_ERROR: typing.ClassVar['OrekitMessages'] = ...
    CANNOT_PARSE_SOURCETABLE: typing.ClassVar['OrekitMessages'] = ...
    MOUNPOINT_ALREADY_CONNECTED: typing.ClassVar['OrekitMessages'] = ...
    MISSING_HEADER: typing.ClassVar['OrekitMessages'] = ...
    NOT_VALID_INTERNATIONAL_DESIGNATOR: typing.ClassVar['OrekitMessages'] = ...
    UNINITIALIZED_VALUE_FOR_KEY: typing.ClassVar['OrekitMessages'] = ...
    UNKNOWN_UNIT: typing.ClassVar['OrekitMessages'] = ...
    INCOMPATIBLE_UNITS: typing.ClassVar['OrekitMessages'] = ...
    MISSING_VELOCITY: typing.ClassVar['OrekitMessages'] = ...
    ATTEMPT_TO_GENERATE_MALFORMED_FILE: typing.ClassVar['OrekitMessages'] = ...
    FIND_ROOT: typing.ClassVar['OrekitMessages'] = ...
    BACKWARD_PROPAGATION_NOT_ALLOWED: typing.ClassVar['OrekitMessages'] = ...
    NO_STATION_ECCENTRICITY_FOR_EPOCH: typing.ClassVar['OrekitMessages'] = ...
    INCONSISTENT_SELECTION: typing.ClassVar['OrekitMessages'] = ...
    NOT_STRICTLY_POSITIVE: typing.ClassVar['OrekitMessages'] = ...
    def getLocalizedString(self, locale: java.util.Locale) -> str:
        """
        
            Specified by:
                 in interface 
        
        
        """
        ...
    def getSourceString(self) -> str:
        """
        
            Specified by:
                 in interface 
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'OrekitMessages':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (String): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                : if this enum type has no constant with the specified name
                : if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.List['OrekitMessages']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            

            for (OrekitMessages c : OrekitMessages.values())

                System.out.println(c);

            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...
    class UTF8Control(java.util.ResourceBundle.Control):
        def __init__(self): ...
        def newBundle(self, string: str, locale: java.util.Locale, string2: str, classLoader: java.lang.ClassLoader, boolean: bool) -> java.util.ResourceBundle: ...

class OrekitException(java.lang.RuntimeException, LocalizedException):
    """
    public class OrekitException extends RuntimeException implements :class:`~org.orekit.errors.LocalizedException`
    
        This class is the base class for all specific exceptions thrown by the Orekit classes.
    
        When the Orekit classes throw exceptions that are specific to the package, these exceptions are always subclasses of
        OrekitException. When exceptions that are already covered by the standard java API should be thrown, like
        ArrayIndexOutOfBoundsException or InvalidParameterException, these standard exceptions are thrown rather than the
        Hipparchus specific ones.
    
        This class also provides utility methods to throw some standard java exceptions with localized messages.
    
        Also see:
            :meth:`~serialized`
    """
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    @typing.overload
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    @typing.overload
    def __init__(self, localizable: org.hipparchus.exception.Localizable, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, mathRuntimeException: org.hipparchus.exception.MathRuntimeException): ...
    @typing.overload
    def __init__(self, orekitException: 'OrekitException'): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...
    @staticmethod
    def unwrap(mathRuntimeException: org.hipparchus.exception.MathRuntimeException) -> 'OrekitException':
        """
            Recover a OrekitException, possibly embedded in a null.
        
            If the :code:`MathRuntimeException` does not embed a OrekitException, a new one will be created.
        
            Parameters:
                exception (MathRuntimeException): MathRuntimeException to analyze
        
            Returns:
                a (possibly embedded) OrekitException
        
        
        """
        ...

class OrekitIOException(java.io.IOException, LocalizedException):
    """
    public class OrekitIOException extends IOException implements :class:`~org.orekit.errors.LocalizedException`
    
        Extension of null with localized message.
    
        Since:
            9.2
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class OrekitIllegalArgumentException(java.lang.IllegalArgumentException, LocalizedException):
    """
    public class OrekitIllegalArgumentException extends IllegalArgumentException implements :class:`~org.orekit.errors.LocalizedException`
    
        Extension of null with localized message.
    
        Since:
            7.1
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class OrekitIllegalStateException(java.lang.IllegalStateException, LocalizedException):
    """
    public class OrekitIllegalStateException extends IllegalStateException implements :class:`~org.orekit.errors.LocalizedException`
    
        Extension of null with localized message.
    
        Since:
            7.1
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class OrekitInternalError(java.lang.IllegalStateException, LocalizedException):
    """
    public class OrekitInternalError extends IllegalStateException implements :class:`~org.orekit.errors.LocalizedException`
    
        Extension of null with localized message for internal errors only.
    
        Since:
            7.1
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, throwable: java.lang.Throwable): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class OrekitParseException(java.text.ParseException, LocalizedException):
    """
    public class OrekitParseException extends ParseException implements :class:`~org.orekit.errors.LocalizedException`
    
        Extension of null with localized message.
    
        Since:
            7.1
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    def getLocalizedMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self) -> str:
        """
        
            Overrides:
                 in class 
        
        
        """
        ...
    @typing.overload
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...

class PythonLocalizedException(LocalizedException):
    """
    public class PythonLocalizedException extends Object implements :class:`~org.orekit.errors.LocalizedException`
    """
    def __init__(self): ...
    def finalize(self) -> None: ...
    def getMessage(self, locale: java.util.Locale) -> str:
        """
            Gets the message in a specified locale.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getMessage` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Parameters:
                locale (Locale): Locale in which the message should be translated
        
            Returns:
                localized message
        
        
        """
        ...
    def getParts(self) -> typing.List[typing.Any]:
        """
            Get the variable parts of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getParts` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                a copy of the variable parts of the error message
        
        
        """
        ...
    def getSpecifier(self) -> org.hipparchus.exception.Localizable:
        """
            Get the localizable specifier of the error message.
        
            Specified by:
                :meth:`~org.orekit.errors.LocalizedException.getSpecifier` in interface :class:`~org.orekit.errors.LocalizedException`
        
            Returns:
                localizable specifier of the error message
        
        
        """
        ...
    def pythonDecRef(self) -> None:
        """
            Part of JCC Python interface to object
        
        """
        ...
    @typing.overload
    def pythonExtension(self) -> int:
        """
            Part of JCC Python interface to object
        
        """
        ...
    @typing.overload
    def pythonExtension(self, long: int) -> None:
        """
            Part of JCC Python interface to object
        """
        ...

class FrameAncestorException(OrekitException):
    """
    public class FrameAncestorException extends :class:`~org.orekit.errors.OrekitException`
    
        This class is the base class for exception thrown by the :meth:`~org.orekit.frames.UpdatableFrame.updateTransform`
        method.
    
        Also see:
            :meth:`~serialized`
    """
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...

class TimeStampedCacheException(OrekitException):
    """
    public class TimeStampedCacheException extends :class:`~org.orekit.errors.OrekitException`
    
        This class is the base class for all specific exceptions thrown by during the
        :class:`~org.orekit.utils.GenericTimeStampedCache`.
    
        Also see:
            :meth:`~serialized`
    """
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    @typing.overload
    def __init__(self, localizable: org.hipparchus.exception.Localizable, *object: typing.Any): ...
    @typing.overload
    def __init__(self, mathRuntimeException: org.hipparchus.exception.MathRuntimeException): ...
    @typing.overload
    def __init__(self, orekitException: OrekitException): ...
    @typing.overload
    @staticmethod
    def unwrap(mathRuntimeException: org.hipparchus.exception.MathRuntimeException) -> OrekitException:
        """
            Recover a TimeStampedCacheException, possibly embedded in a :class:`~org.orekit.errors.OrekitException`.
        
            If the :code:`OrekitException` does not embed a TimeStampedCacheException, a new one will be created.
        
            Parameters:
                oe (:class:`~org.orekit.errors.OrekitException`): OrekitException to analyze
        
            Returns:
                a (possibly embedded) TimeStampedCacheException
        
            Recover a TimeStampedCacheException, possibly embedded in a null.
        
            If the :code:`MathRuntimeException` does not embed a TimeStampedCacheException, a new one will be created.
        
            Parameters:
                exception (MathRuntimeException): MathRuntimeException to analyze
        
            Returns:
                a (possibly embedded) TimeStampedCacheException
        
        
        """
        ...
    @typing.overload
    @staticmethod
    def unwrap(mathRuntimeException: org.hipparchus.exception.MathRuntimeException) -> 'TimeStampedCacheException': ...
    @typing.overload
    @staticmethod
    def unwrap(orekitException: OrekitException) -> 'TimeStampedCacheException': ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.orekit.errors")``.

    FrameAncestorException: typing.Type[FrameAncestorException]
    LocalizedException: typing.Type[LocalizedException]
    OrekitException: typing.Type[OrekitException]
    OrekitIOException: typing.Type[OrekitIOException]
    OrekitIllegalArgumentException: typing.Type[OrekitIllegalArgumentException]
    OrekitIllegalStateException: typing.Type[OrekitIllegalStateException]
    OrekitInternalError: typing.Type[OrekitInternalError]
    OrekitMessages: typing.Type[OrekitMessages]
    OrekitParseException: typing.Type[OrekitParseException]
    PythonLocalizedException: typing.Type[PythonLocalizedException]
    TimeStampedCacheException: typing.Type[TimeStampedCacheException]
