/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.CelestialBody;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;

public class FieldDSSTThirdBodyContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    private static final int MAX_POWER = 22;
    private static final double BIG_TRUNCATION_TOLERANCE = 0.1;
    private static final double SMALL_TRUNCATION_TOLERANCE = 1.9E-6;
    private static final int MAX_ECCPOWER_SP = 4;
    private int maxAR3Pow;
    private int maxEccPow;
    private T[] aoR3Pow;
    private int maxEccPowShort;
    private int maxFreqF;
    private T[][] Qns;
    private final T gm;
    private T R3;
    private final T A;
    private final T alpha;
    private final T beta;
    private final T gamma;
    private final T BB;
    private final T BBB;
    private final T X;
    private final T XX;
    private final T XXX;
    private final T m2aoA;
    private final T BoA;
    private final T ooAB;
    private final T mCo2AB;
    private final T BoABpo;
    private final T muoR3;
    private final T b;
    private final T hXXX;
    private final T kXXX;
    private final T motion;

    FieldDSSTThirdBodyContext(FieldAuxiliaryElements<T> auxiliaryElements, CelestialBody thirdBody, T[] parameters) {
        super(auxiliaryElements);
        Field<T> field = auxiliaryElements.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        T mu = parameters[1];
        this.A = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.multiply(auxiliaryElements.getSma())));
        this.gm = parameters[0];
        CalculusFieldElement absA = FastMath.abs(auxiliaryElements.getSma());
        this.motion = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.divide((FieldElement)absA))).divide((FieldElement)absA);
        FieldVector3D bodyPos = thirdBody.getPVCoordinates(auxiliaryElements.getDate(), auxiliaryElements.getFrame()).getPosition();
        this.R3 = bodyPos.getNorm();
        FieldVector3D bodyDir = bodyPos.normalize();
        this.alpha = bodyDir.dotProduct(auxiliaryElements.getVectorF());
        this.beta = bodyDir.dotProduct(auxiliaryElements.getVectorG());
        this.gamma = bodyDir.dotProduct(auxiliaryElements.getVectorW());
        this.BB = (CalculusFieldElement)auxiliaryElements.getB().multiply(auxiliaryElements.getB());
        this.BBB = (CalculusFieldElement)this.BB.multiply(auxiliaryElements.getB());
        this.b = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getB().add(1.0)).reciprocal();
        this.X = (CalculusFieldElement)auxiliaryElements.getB().reciprocal();
        this.XX = (CalculusFieldElement)this.X.multiply(this.X);
        this.XXX = (CalculusFieldElement)this.X.multiply(this.XX);
        this.m2aoA = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getSma().multiply(-2.0)).divide(this.A);
        this.BoA = (CalculusFieldElement)auxiliaryElements.getB().divide(this.A);
        this.ooAB = (CalculusFieldElement)((CalculusFieldElement)this.A.multiply(auxiliaryElements.getB())).reciprocal();
        this.mCo2AB = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0)).negate();
        this.BoABpo = (CalculusFieldElement)this.BoA.divide((FieldElement)((CalculusFieldElement)auxiliaryElements.getB().add(1.0)));
        this.muoR3 = (CalculusFieldElement)((CalculusFieldElement)this.R3.divide(this.gm)).reciprocal();
        this.hXXX = (CalculusFieldElement)this.XXX.multiply(auxiliaryElements.getH());
        this.kXXX = (CalculusFieldElement)this.XXX.multiply(auxiliaryElements.getK());
        CalculusFieldElement aoR3 = (CalculusFieldElement)auxiliaryElements.getSma().divide(this.R3);
        double tol = aoR3.getReal() > 0.3 || aoR3.getReal() > 0.15 && auxiliaryElements.getEcc().getReal() > 0.25 ? 0.1 : 1.9E-6;
        CalculusFieldElement eo2 = FastMath.max((CalculusFieldElement)((CalculusFieldElement)zero.add(0.0025)), (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getEcc().divide(2.0)));
        CalculusFieldElement x2o2 = (CalculusFieldElement)this.XX.divide(2.0);
        CalculusFieldElement[] eccPwr = (CalculusFieldElement[])MathArrays.buildArray(field, (int)22);
        CalculusFieldElement[] chiPwr = (CalculusFieldElement[])MathArrays.buildArray(field, (int)22);
        eccPwr[0] = (CalculusFieldElement)zero.add(1.0);
        chiPwr[0] = this.X;
        for (int i = 1; i < 22; ++i) {
            eccPwr[i] = (CalculusFieldElement)eccPwr[i - 1].multiply((FieldElement)eo2);
            chiPwr[i] = (CalculusFieldElement)chiPwr[i - 1].multiply((FieldElement)x2o2);
        }
        CalculusFieldElement ao2rxx = (CalculusFieldElement)aoR3.divide((FieldElement)((CalculusFieldElement)this.XX.multiply(2.0)));
        CalculusFieldElement xmuarn = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ao2rxx.multiply((FieldElement)ao2rxx)).multiply(this.gm)).divide((FieldElement)((CalculusFieldElement)this.X.multiply(this.R3)));
        CalculusFieldElement term = zero;
        this.maxAR3Pow = 2;
        this.maxEccPow = 0;
        int n = 2;
        int m = 2;
        int nsmd2 = 0;
        do {
            if ((term = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xmuarn.multiply(CombinatoricsUtils.factorialDouble((int)(n + m)) / (CombinatoricsUtils.factorialDouble((int)nsmd2) * CombinatoricsUtils.factorialDouble((int)(nsmd2 + m))) * (CombinatoricsUtils.factorialDouble((int)(n + m + 1)) / (CombinatoricsUtils.factorialDouble((int)m) * CombinatoricsUtils.factorialDouble((int)(n + 1)))) * (CombinatoricsUtils.factorialDouble((int)(n - m + 1)) / CombinatoricsUtils.factorialDouble((int)(n + 1))))).multiply((FieldElement)eccPwr[m])).multiply((FieldElement)UpperBounds.getDnl(this.XX, chiPwr[m], n + 2, m))).getReal() < tol) {
                if (m == 0) break;
                if (m < 2) {
                    xmuarn = (CalculusFieldElement)xmuarn.multiply((FieldElement)ao2rxx);
                    m = 0;
                    ++n;
                    ++nsmd2;
                    continue;
                }
                m -= 2;
                ++nsmd2;
                continue;
            }
            this.maxAR3Pow = n++;
            this.maxEccPow = FastMath.max((int)m, (int)this.maxEccPow);
            xmuarn = (CalculusFieldElement)xmuarn.multiply((FieldElement)ao2rxx);
            ++m;
        } while (n < 22);
        this.maxEccPow = FastMath.min((int)this.maxAR3Pow, (int)this.maxEccPow);
        this.aoR3Pow = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(this.maxAR3Pow + 1));
        this.aoR3Pow[0] = (CalculusFieldElement)field.getOne();
        for (int i = 1; i <= this.maxAR3Pow; ++i) {
            this.aoR3Pow[i] = (CalculusFieldElement)aoR3.multiply(this.aoR3Pow[i - 1]);
        }
        this.maxFreqF = this.maxAR3Pow + 1;
        this.maxEccPowShort = 4;
        this.Qns = CoefficientsFactory.computeQns(this.gamma, (int)this.maxAR3Pow, (int)FastMath.max((int)this.maxEccPow, (int)this.maxEccPowShort));
    }

    public T getA() {
        return this.A;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }

    public T getBB() {
        return this.BB;
    }

    public T getBBB() {
        return this.BBB;
    }

    public T getb() {
        return this.b;
    }

    public T getX() {
        return this.X;
    }

    public T getM2aoA() {
        return this.m2aoA;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getMCo2AB() {
        return this.mCo2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMuoR3() {
        return this.muoR3;
    }

    public T getHXXX() {
        return this.hXXX;
    }

    public T getKXXX() {
        return this.kXXX;
    }

    public int getMaxAR3Pow() {
        return this.maxAR3Pow;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public T[] getAoR3Pow() {
        return (CalculusFieldElement[])this.aoR3Pow.clone();
    }

    public int getMaxFreqF() {
        return this.maxFreqF;
    }

    public T getMeanMotion() {
        return this.motion;
    }

    public T[][] getQns() {
        return (CalculusFieldElement[][])this.Qns.clone();
    }
}

