/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.propagation.semianalytical.dsst.DSSTGradientConverter;
import org.orekit.propagation.semianalytical.dsst.DSSTJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

@Deprecated
public class DSSTPartialDerivativesEquations
implements AdditionalDerivativesProvider,
AdditionalEquations {
    private static final int I = 1;
    private final DSSTPropagator propagator;
    private ParameterDriversList selected;
    private Map<ParameterDriver, Integer> map;
    private final String name;
    private boolean initialized;
    private PropagationType propagationType;

    public DSSTPartialDerivativesEquations(String name, DSSTPropagator propagator, PropagationType propagationType) {
        this.name = name;
        this.selected = null;
        this.map = null;
        this.propagator = propagator;
        this.initialized = false;
        this.propagationType = propagationType;
        propagator.addAdditionalDerivativesProvider(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDimension() {
        this.freezeParametersSelection();
        return 6 * (6 + this.selected.getNbParams());
    }

    private void freezeParametersSelection() {
        if (this.selected == null) {
            this.selected = new ParameterDriversList();
            for (DSSTForceModel provider : this.propagator.getAllForceModels()) {
                for (ParameterDriver driver : provider.getParametersDrivers()) {
                    this.selected.add(driver);
                }
            }
            this.selected.filter(true);
            this.selected.sort();
            this.map = new IdentityHashMap<ParameterDriver, Integer>();
            int parameterIndex = 0;
            for (ParameterDriver parameterDriver : this.selected.getDrivers()) {
                for (DSSTForceModel provider : this.propagator.getAllForceModels()) {
                    for (ParameterDriver driver : provider.getParametersDrivers()) {
                        if (!driver.getName().equals(parameterDriver.getName())) continue;
                        this.map.put(driver, parameterIndex);
                    }
                }
                ++parameterIndex;
            }
        }
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s0) {
        this.freezeParametersSelection();
        int stateDimension = 6;
        double[][] dYdY0 = new double[6][6];
        double[][] dYdP = new double[6][this.selected.getNbParams()];
        for (int i = 0; i < 6; ++i) {
            dYdY0[i][i] = 1.0;
        }
        return this.setInitialJacobians(s0, dYdY0, dYdP);
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s1, double[][] dY1dY0, double[][] dY1dP) {
        this.freezeParametersSelection();
        int stateDim = dY1dY0.length;
        if (stateDim != 6 || stateDim != dY1dY0[0].length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_6X6, stateDim, dY1dY0[0].length);
        }
        if (dY1dP != null && stateDim != dY1dP.length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH, stateDim, dY1dP.length);
        }
        if (dY1dP == null && this.selected.getNbParams() != 0 || dY1dP != null && this.selected.getNbParams() != dY1dP[0].length) {
            throw new OrekitException(new OrekitException((Localizable)OrekitMessages.INITIAL_MATRIX_AND_PARAMETERS_NUMBER_MISMATCH, dY1dP == null ? 0 : dY1dP[0].length, this.selected.getNbParams()));
        }
        this.initialized = true;
        DSSTJacobiansMapper mapper = this.getMapper();
        double[] p = new double[mapper.getAdditionalStateDimension()];
        mapper.setInitialJacobians(s1, dY1dY0, dY1dP, p);
        return s1.addAdditionalState(this.name, p);
    }

    public DSSTJacobiansMapper getMapper() {
        if (!this.initialized) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_INITIALIZED, new Object[0]);
        }
        return new DSSTJacobiansMapper(this.name, this.selected, this.propagator, this.map, this.propagationType);
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        AdditionalDerivativesProvider.super.init(initialState, target);
    }

    @Override
    public double[] computeDerivatives(SpacecraftState s, double[] pDot) {
        System.arraycopy(this.derivatives(s), 0, pDot, 0, pDot.length);
        return null;
    }

    @Override
    @Deprecated
    public double[] derivatives(SpacecraftState state) {
        return this.combinedDerivatives(state).getAdditionalDerivatives();
    }

    @Override
    public CombinedDerivatives combinedDerivatives(SpacecraftState s) {
        int paramDim = this.selected.getNbParams();
        int dim = 6;
        double[][] dMeanElementRatedParam = new double[6][paramDim];
        double[][] dMeanElementRatedElement = new double[6][6];
        DSSTGradientConverter converter = new DSSTGradientConverter(s, this.propagator.getAttitudeProvider());
        for (DSSTForceModel forceModel : this.propagator.getAllForceModels()) {
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient[] parameters = converter.getParameters(dsState, forceModel);
            FieldAuxiliaryElements<Gradient> auxiliaryElements = new FieldAuxiliaryElements<Gradient>(dsState.getOrbit(), 1);
            forceModel.initializeShortPeriodTerms(auxiliaryElements, this.propagationType, (CalculusFieldElement[])parameters);
            Gradient[] meanElementRate = (Gradient[])forceModel.getMeanElementRate(dsState, auxiliaryElements, (CalculusFieldElement[])parameters);
            double[] derivativesA = meanElementRate[0].getGradient();
            double[] derivativesEx = meanElementRate[1].getGradient();
            double[] derivativesEy = meanElementRate[2].getGradient();
            double[] derivativesHx = meanElementRate[3].getGradient();
            double[] derivativesHy = meanElementRate[4].getGradient();
            double[] derivativesL = meanElementRate[5].getGradient();
            this.addToRow(derivativesA, 0, dMeanElementRatedElement);
            this.addToRow(derivativesEx, 1, dMeanElementRatedElement);
            this.addToRow(derivativesEy, 2, dMeanElementRatedElement);
            this.addToRow(derivativesHx, 3, dMeanElementRatedElement);
            this.addToRow(derivativesHy, 4, dMeanElementRatedElement);
            this.addToRow(derivativesL, 5, dMeanElementRatedElement);
            int index = converter.getFreeStateParameters();
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                int parameterIndex = this.map.get(driver);
                double[] dArray = dMeanElementRatedParam[0];
                int n = parameterIndex;
                dArray[n] = dArray[n] + derivativesA[index];
                double[] dArray2 = dMeanElementRatedParam[1];
                int n2 = parameterIndex;
                dArray2[n2] = dArray2[n2] + derivativesEx[index];
                double[] dArray3 = dMeanElementRatedParam[2];
                int n3 = parameterIndex;
                dArray3[n3] = dArray3[n3] + derivativesEy[index];
                double[] dArray4 = dMeanElementRatedParam[3];
                int n4 = parameterIndex;
                dArray4[n4] = dArray4[n4] + derivativesHx[index];
                double[] dArray5 = dMeanElementRatedParam[4];
                int n5 = parameterIndex;
                dArray5[n5] = dArray5[n5] + derivativesHy[index];
                double[] dArray6 = dMeanElementRatedParam[5];
                int n6 = parameterIndex;
                dArray6[n6] = dArray6[n6] + derivativesL[index];
                ++index;
            }
        }
        double[] p = s.getAdditionalState(this.getName());
        double[] pDot = new double[p.length];
        for (int i = 0; i < 6; ++i) {
            double[] dMeanElementRatedElementi = dMeanElementRatedElement[i];
            for (int j = 0; j < 6; ++j) {
                pDot[j + 6 * i] = dMeanElementRatedElementi[0] * p[j] + dMeanElementRatedElementi[1] * p[j + 6] + dMeanElementRatedElementi[2] * p[j + 12] + dMeanElementRatedElementi[3] * p[j + 18] + dMeanElementRatedElementi[4] * p[j + 24] + dMeanElementRatedElementi[5] * p[j + 30];
            }
        }
        int columnTop = 36;
        for (int k = 0; k < paramDim; ++k) {
            for (int i = 0; i < 6; ++i) {
                double[] dMeanElementRatedElementi = dMeanElementRatedElement[i];
                pDot[36 + (i + 6 * k)] = dMeanElementRatedParam[i][k] + dMeanElementRatedElementi[0] * p[36 + k] + dMeanElementRatedElementi[1] * p[36 + k + paramDim] + dMeanElementRatedElementi[2] * p[36 + k + 2 * paramDim] + dMeanElementRatedElementi[3] * p[36 + k + 3 * paramDim] + dMeanElementRatedElementi[4] * p[36 + k + 4 * paramDim] + dMeanElementRatedElementi[5] * p[36 + k + 5 * paramDim];
            }
        }
        return new CombinedDerivatives(pDot, null);
    }

    private void addToRow(double[] derivatives, int index, double[][] dMeanElementRatedElement) {
        for (int i = 0; i < 6; ++i) {
            double[] dArray = dMeanElementRatedElement[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i];
        }
    }
}

