/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

class DSSTGradientConverter
extends AbstractGradientConverter {
    private static final int FREE_STATE_PARAMETERS = 6;

    DSSTGradientConverter(SpacecraftState state, AttitudeProvider provider) {
        super(6);
        Gradient sma = Gradient.variable((int)6, (int)0, (double)state.getA());
        Gradient ex = Gradient.variable((int)6, (int)1, (double)state.getEquinoctialEx());
        Gradient ey = Gradient.variable((int)6, (int)2, (double)state.getEquinoctialEy());
        Gradient hx = Gradient.variable((int)6, (int)3, (double)state.getHx());
        Gradient hy = Gradient.variable((int)6, (int)4, (double)state.getHy());
        Gradient l = Gradient.variable((int)6, (int)5, (double)state.getLM());
        Gradient gMu = Gradient.constant((int)6, (double)state.getMu());
        AbsoluteDate date = state.getDate();
        FieldAbsoluteDate dateField = new FieldAbsoluteDate(sma.getField(), date);
        Gradient gM = Gradient.constant((int)6, (double)state.getMass());
        FieldEquinoctialOrbit<Gradient> gOrbit = new FieldEquinoctialOrbit<Gradient>(sma, ex, ey, hx, hy, l, PositionAngle.MEAN, state.getFrame(), dateField, gMu);
        FieldAttitude<Gradient> gAttitude = provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame());
        this.initStates(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
    }
}

