/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.List;
import org.hipparchus.linear.RealMatrix;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.DoubleArrayDictionary;

class NumericalPropagationHarvester
extends AbstractMatricesHarvester {
    private final NumericalPropagator propagator;
    private List<String> columnsNames;

    NumericalPropagationHarvester(NumericalPropagator propagator, String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        super(stmName, initialStm, initialJacobianColumns);
        this.propagator = propagator;
        this.columnsNames = null;
    }

    @Override
    protected double[][] getConversionJacobian(SpacecraftState state) {
        double[][] dYdC = new double[6][6];
        if (state.isOrbitDefined()) {
            Orbit orbit = this.propagator.getOrbitType().convertType(state.getOrbit());
            orbit.getJacobianWrtCartesian(this.propagator.getPositionAngleType(), dYdC);
        } else {
            for (int i = 0; i < 6; ++i) {
                dYdC[i][i] = 1.0;
            }
        }
        return dYdC;
    }

    @Override
    public void freezeColumnsNames() {
        this.columnsNames = this.getJacobiansColumnsNames();
    }

    @Override
    public List<String> getJacobiansColumnsNames() {
        return this.columnsNames == null ? this.propagator.getJacobiansColumnsNames() : this.columnsNames;
    }
}

