/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.FieldDenseOutputModel;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.FieldSecondaryODE;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldEventHandlerConfiguration;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldAbstractPropagator;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldEphemerisGenerator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.integration.FieldAdditionalDerivativesProvider;
import org.orekit.propagation.integration.FieldAdditionalEquations;
import org.orekit.propagation.integration.FieldAdditionalEquationsAdapter;
import org.orekit.propagation.integration.FieldCombinedDerivatives;
import org.orekit.propagation.integration.FieldIntegratedEphemeris;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldArrayDictionary;

public abstract class FieldAbstractIntegratedPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractPropagator<T> {
    private static final String SECONDARY_DIMENSION = "Orekit-secondary-dimension";
    private final List<FieldEventDetector<T>> detectors = new ArrayList<FieldEventDetector<T>>();
    private final List<FieldStoringStepHandler> ephemerisGenerators = new ArrayList<FieldStoringStepHandler>();
    private final FieldODEIntegrator<T> integrator;
    private final Map<String, Integer> secondaryOffsets;
    private List<FieldAdditionalDerivativesProvider<T>> additionalDerivativesProviders = new ArrayList<FieldAdditionalDerivativesProvider<T>>();
    private int calls;
    private FieldStateMapper<T> stateMapper;
    private boolean resetAtEnd;
    private PropagationType propagationType;

    protected FieldAbstractIntegratedPropagator(Field<T> field, FieldODEIntegrator<T> integrator, PropagationType propagationType) {
        super(field);
        this.secondaryOffsets = new HashMap<String, Integer>();
        this.integrator = integrator;
        this.propagationType = propagationType;
        this.resetAtEnd = true;
    }

    public void setResetAtEnd(boolean resetAtEnd) {
        this.resetAtEnd = resetAtEnd;
    }

    protected void initMapper(Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        this.stateMapper = this.createMapper(null, (CalculusFieldElement)zero.add(Double.NaN), null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    protected PropagationType isMeanOrbit() {
        return this.propagationType;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(T mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public T getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (FieldAdditionalDerivativesProvider<T> provider : this.additionalDerivativesProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalDerivativesProviders.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalDerivativesProviders.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalDerivativesProviders.get(i).getName();
        }
        return managed;
    }

    @Deprecated
    public void addAdditionalEquations(FieldAdditionalEquations<T> additional) {
        this.addAdditionalDerivativesProvider(new FieldAdditionalEquationsAdapter<T>(additional, this::getInitialState));
    }

    public void addAdditionalDerivativesProvider(FieldAdditionalDerivativesProvider<T> provider) {
        if (this.isAdditionalStateManaged(provider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, provider.getName());
        }
        this.additionalDerivativesProviders.add(provider);
        this.secondaryOffsets.clear();
    }

    public List<FieldAdditionalDerivativesProvider<T>> getAdditionalDerivativesProviders() {
        return Collections.unmodifiableList(this.additionalDerivativesProviders);
    }

    @Override
    public <D extends FieldEventDetector<T>> void addEventDetector(D detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<FieldEventDetector<T>> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (FieldEventDetector<T> detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(FieldODEIntegrator<T> integ, FieldEventDetector<T> detector) {
        integ.addEventHandler((FieldODEEventHandler)new FieldAdaptedEventDetector(detector), detector.getMaxCheckInterval().getReal(), detector.getThreshold().getReal(), detector.getMaxIterationCount());
    }

    @Override
    public FieldEphemerisGenerator<T> getEphemerisGenerator() {
        FieldStoringStepHandler storingHandler = new FieldStoringStepHandler();
        this.ephemerisGenerators.add(storingHandler);
        return storingHandler;
    }

    protected abstract FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> var1, T var2, OrbitType var3, PositionAngle var4, AttitudeProvider var5, Frame var6);

    protected abstract MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> var1);

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> target) {
        if (this.getStartDate() == null) {
            if (this.getInitialState() == null) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            this.setStartDate(this.getInitialState().getDate());
        }
        return this.propagate(this.getStartDate(), target);
    }

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> tStart, FieldAbsoluteDate<T> tEnd) {
        if (this.getInitialState() == null) {
            throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
        }
        try (IntegratorResetter<T> resetter = new IntegratorResetter<T>(this.integrator);){
            this.initializeAdditionalStates(tEnd);
            if (!tStart.equals(this.getInitialState().getDate())) {
                try (IntegratorResetter<T> startResetter = new IntegratorResetter<T>(this.integrator);){
                    this.integrateDynamics(tStart);
                }
            }
            this.setUpUserEventDetectors();
            for (FieldOrekitStepHandler handler : this.getMultiplexer().getHandlers()) {
                this.integrator.addStepHandler((FieldODEStepHandler)new FieldAdaptedStepHandler(handler));
            }
            for (FieldStoringStepHandler generator : this.ephemerisGenerators) {
                generator.setEndDate(tEnd);
                this.integrator.addStepHandler((FieldODEStepHandler)generator);
            }
            FieldSpacecraftState<T> fieldSpacecraftState = this.integrateDynamics(tEnd);
            return fieldSpacecraftState;
        }
    }

    private FieldSpacecraftState<T> integrateDynamics(FieldAbsoluteDate<T> tEnd) {
        try {
            this.initializePropagation();
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            if (Double.isNaN(this.getMu().getReal())) {
                this.setMu(this.getInitialState().getMu());
            }
            if (this.getInitialState().getMass().getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            FieldSpacecraftState<T> initialIntegrationState = this.getInitialIntegrationState();
            FieldODEState<T> mathInitialState = this.createInitialState(initialIntegrationState);
            FieldExpandableODE<T> mathODE = this.createODE(this.integrator, mathInitialState);
            this.beforeIntegration(initialIntegrationState, tEnd);
            FieldODEStateAndDerivative mathFinalState = this.integrator.integrate(mathODE, mathInitialState, tEnd.durationFrom(this.getInitialState().getDate()));
            this.afterIntegration();
            FieldSpacecraftState finalState = this.stateMapper.mapArrayToState(this.stateMapper.mapDoubleToDate(mathFinalState.getTime(), tEnd), mathFinalState.getPrimaryState(), mathFinalState.getPrimaryDerivative(), this.propagationType);
            if (!this.additionalDerivativesProviders.isEmpty()) {
                CalculusFieldElement[] secondary = mathFinalState.getSecondaryState(1);
                CalculusFieldElement[] secondaryDerivatives = mathFinalState.getSecondaryDerivative(1);
                for (FieldAdditionalDerivativesProvider<T> provider : this.additionalDerivativesProviders) {
                    String name = provider.getName();
                    int offset = this.secondaryOffsets.get(name);
                    int dimension = provider.getDimension();
                    finalState = finalState.addAdditionalState(name, Arrays.copyOfRange(secondary, offset, offset + dimension)).addAdditionalStateDerivative(name, Arrays.copyOfRange(secondaryDerivatives, offset, offset + dimension));
                }
            }
            finalState = this.updateAdditionalStates(finalState);
            if (this.resetAtEnd) {
                this.resetInitialState(finalState);
                this.setStartDate(finalState.getDate());
            }
            return finalState;
        }
        catch (OrekitException pe) {
            throw pe;
        }
        catch (MathIllegalArgumentException | MathIllegalStateException me) {
            throw OrekitException.unwrap((MathRuntimeException)me);
        }
    }

    protected FieldSpacecraftState<T> getInitialIntegrationState() {
        return this.getInitialState();
    }

    private FieldODEState<T> createInitialState(FieldSpacecraftState<T> initialState) {
        CalculusFieldElement[] primary = (CalculusFieldElement[])MathArrays.buildArray((Field)initialState.getA().getField(), (int)this.getBasicDimension());
        this.stateMapper.mapStateToArray(initialState, primary, null);
        if (this.secondaryOffsets.isEmpty()) {
            int offset = 0;
            for (FieldAdditionalDerivativesProvider<T> provider : this.additionalDerivativesProviders) {
                this.secondaryOffsets.put(provider.getName(), offset);
                offset += provider.getDimension();
            }
            this.secondaryOffsets.put(SECONDARY_DIMENSION, offset);
        }
        return new FieldODEState((CalculusFieldElement)initialState.getA().getField().getZero(), primary, this.secondary(initialState));
    }

    private T[][] secondary(FieldSpacecraftState<T> state) {
        if (this.secondaryOffsets.isEmpty()) {
            return null;
        }
        CalculusFieldElement[][] secondary = (CalculusFieldElement[][])MathArrays.buildArray(state.getDate().getField(), (int)1, (int)this.secondaryOffsets.get(SECONDARY_DIMENSION));
        for (FieldAdditionalDerivativesProvider<T> provider : this.additionalDerivativesProviders) {
            String name = provider.getName();
            int offset = this.secondaryOffsets.get(name);
            CalculusFieldElement[] additional = state.getAdditionalState(name);
            System.arraycopy(additional, 0, secondary[0], offset, additional.length);
        }
        return secondary;
    }

    private T[][] secondaryDerivative(FieldSpacecraftState<T> state) {
        if (this.secondaryOffsets.isEmpty()) {
            return null;
        }
        CalculusFieldElement[][] secondaryDerivative = (CalculusFieldElement[][])MathArrays.buildArray(state.getDate().getField(), (int)1, (int)this.secondaryOffsets.get(SECONDARY_DIMENSION));
        for (FieldAdditionalDerivativesProvider<T> providcer : this.additionalDerivativesProviders) {
            String name = providcer.getName();
            int offset = this.secondaryOffsets.get(name);
            CalculusFieldElement[] additionalDerivative = state.getAdditionalStateDerivative(name);
            System.arraycopy(additionalDerivative, 0, secondaryDerivative[0], offset, additionalDerivative.length);
        }
        return secondaryDerivative;
    }

    private FieldExpandableODE<T> createODE(FieldODEIntegrator<T> integ, FieldODEState<T> mathInitialState) {
        FieldExpandableODE ode = new FieldExpandableODE((FieldOrdinaryDifferentialEquation)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        if (!this.additionalDerivativesProviders.isEmpty()) {
            ode.addSecondaryEquations((FieldSecondaryODE)new ConvertedSecondaryStateEquations());
        }
        return ode;
    }

    protected void beforeIntegration(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> tEnd) {
    }

    protected void afterIntegration() {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected FieldODEIntegrator<T> getIntegrator() {
        return this.integrator;
    }

    private FieldSpacecraftState<T> convert(FieldODEStateAndDerivative<T> os) {
        FieldSpacecraftState s = this.stateMapper.mapArrayToState(os.getTime(), os.getPrimaryState(), os.getPrimaryDerivative(), this.propagationType);
        if (os.getNumberOfSecondaryStates() > 0) {
            CalculusFieldElement[] secondary = os.getSecondaryState(1);
            CalculusFieldElement[] secondaryDerivative = os.getSecondaryDerivative(1);
            for (FieldAdditionalDerivativesProvider<T> equations : this.additionalDerivativesProviders) {
                String name = equations.getName();
                int offset = this.secondaryOffsets.get(name);
                int dimension = equations.getDimension();
                s = s.addAdditionalState(name, Arrays.copyOfRange(secondary, offset, offset + dimension));
                s = s.addAdditionalStateDerivative(name, Arrays.copyOfRange(secondaryDerivative, offset, offset + dimension));
            }
        }
        s = this.updateAdditionalStates(s);
        return s;
    }

    private FieldODEStateAndDerivative<T> convert(FieldSpacecraftState<T> state) {
        CalculusFieldElement[] primary = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getBasicDimension());
        CalculusFieldElement[] primaryDot = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getBasicDimension());
        this.stateMapper.mapStateToArray(state, primary, primaryDot);
        CalculusFieldElement[][] secondary = this.secondary(state);
        CalculusFieldElement[][] secondaryDerivative = this.secondaryDerivative(state);
        return new FieldODEStateAndDerivative(this.stateMapper.mapDateToDouble(state.getDate()), primary, primaryDot, secondary, secondaryDerivative);
    }

    private static class IntegratorResetter<T extends CalculusFieldElement<T>>
    implements AutoCloseable {
        private final FieldODEIntegrator<T> integrator;
        private final List<FieldEventHandlerConfiguration<T>> eventHandlersConfigurations;
        private final List<FieldODEStepHandler<T>> stepHandlers;

        IntegratorResetter(FieldODEIntegrator<T> integrator) {
            this.integrator = integrator;
            this.eventHandlersConfigurations = new ArrayList<FieldEventHandlerConfiguration<T>>(integrator.getEventHandlersConfigurations());
            this.stepHandlers = new ArrayList<FieldODEStepHandler<T>>(integrator.getStepHandlers());
        }

        @Override
        public void close() {
            this.integrator.clearEventHandlers();
            this.eventHandlersConfigurations.forEach(c -> this.integrator.addEventHandler(c.getEventHandler(), c.getMaxCheckInterval(), c.getConvergence().getReal(), c.getMaxIterationCount(), c.getSolver()));
            this.integrator.clearStepHandlers();
            this.stepHandlers.forEach(stepHandler -> this.integrator.addStepHandler(stepHandler));
        }
    }

    private class FieldStoringStepHandler
    implements FieldODEStepHandler<T>,
    FieldEphemerisGenerator<T> {
        private FieldDenseOutputModel<T> model;
        private FieldAbsoluteDate<T> endDate;
        private FieldBoundedPropagator<T> ephemeris;
        private FieldODEStateInterpolator<T> lastInterpolator;

        private FieldStoringStepHandler() {
        }

        public void setEndDate(FieldAbsoluteDate<T> endDate) {
            this.endDate = endDate;
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            this.model = new FieldDenseOutputModel();
            this.model.init(s0, t);
            this.ephemeris = null;
            this.lastInterpolator = null;
        }

        @Override
        public FieldBoundedPropagator<T> getGeneratedEphemeris() {
            this.buildEphemeris();
            return this.ephemeris;
        }

        public void handleStep(FieldODEStateInterpolator<T> interpolator) {
            this.model.handleStep(interpolator);
            this.lastInterpolator = interpolator;
        }

        public void finish(FieldODEStateAndDerivative<T> finalState) {
            this.buildEphemeris();
        }

        private void buildEphemeris() {
            FieldAbsoluteDate<CalculusFieldElement> maxDate;
            FieldAbsoluteDate<CalculusFieldElement> minDate;
            this.model.finish(this.lastInterpolator.getCurrentState());
            CalculusFieldElement tI = this.model.getInitialTime();
            CalculusFieldElement tF = this.model.getFinalTime();
            FieldAbsoluteDate<CalculusFieldElement> startDate = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
            FieldAbsoluteDate<CalculusFieldElement> finalDate = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF, this.endDate);
            if (tF.getReal() < tI.getReal()) {
                minDate = finalDate;
                maxDate = startDate;
            } else {
                minDate = startDate;
                maxDate = finalDate;
            }
            FieldArrayDictionary<CalculusFieldElement> unmanaged = new FieldArrayDictionary<CalculusFieldElement>(startDate.getField());
            for (FieldArrayDictionary.Entry initial : FieldAbstractIntegratedPropagator.this.getInitialState().getAdditionalStatesValues().getData()) {
                if (FieldAbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                unmanaged.put(initial.getKey(), initial.getValue());
            }
            String[] names = new String[FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders.size()];
            int[] dimensions = new int[FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((FieldAdditionalDerivativesProvider)FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders.get(i)).getName();
                dimensions[i] = ((FieldAdditionalDerivativesProvider)FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders.get(i)).getDimension();
            }
            this.ephemeris = new FieldIntegratedEphemeris<CalculusFieldElement>(startDate, minDate, maxDate, FieldAbstractIntegratedPropagator.this.stateMapper, FieldAbstractIntegratedPropagator.this.propagationType, this.model, unmanaged, FieldAbstractIntegratedPropagator.this.getAdditionalStateProviders(), names, dimensions);
        }
    }

    private class FieldAdaptedStepInterpolator
    implements FieldOrekitStepInterpolator<T> {
        private final FieldODEStateInterpolator<T> mathInterpolator;

        FieldAdaptedStepInterpolator(FieldODEStateInterpolator<T> mathInterpolator) {
            this.mathInterpolator = mathInterpolator;
        }

        @Override
        public FieldSpacecraftState<T> getPreviousState() {
            return FieldAbstractIntegratedPropagator.this.convert(this.mathInterpolator.getPreviousState());
        }

        @Override
        public FieldSpacecraftState<T> getCurrentState() {
            return FieldAbstractIntegratedPropagator.this.convert(this.mathInterpolator.getCurrentState());
        }

        @Override
        public FieldSpacecraftState<T> getInterpolatedState(FieldAbsoluteDate<T> date) {
            return FieldAbstractIntegratedPropagator.this.convert(this.mathInterpolator.getInterpolatedState(date.durationFrom(FieldAbstractIntegratedPropagator.this.getStartDate())));
        }

        @Override
        public boolean isForward() {
            return this.mathInterpolator.isForward();
        }

        public FieldAdaptedStepInterpolator restrictStep(FieldSpacecraftState<T> newPreviousState, FieldSpacecraftState<T> newCurrentState) {
            try {
                AbstractFieldODEStateInterpolator aosi = (AbstractFieldODEStateInterpolator)this.mathInterpolator;
                return new FieldAdaptedStepInterpolator(aosi.restrictStep(FieldAbstractIntegratedPropagator.this.convert(newPreviousState), FieldAbstractIntegratedPropagator.this.convert(newCurrentState)));
            }
            catch (ClassCastException cce) {
                throw new OrekitInternalError(cce);
            }
        }
    }

    private class FieldAdaptedStepHandler
    implements FieldODEStepHandler<T> {
        private final FieldOrekitStepHandler<T> handler;

        FieldAdaptedStepHandler(FieldOrekitStepHandler<T> handler) {
            this.handler = handler;
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            this.handler.init(FieldAbstractIntegratedPropagator.this.convert(s0), FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
        }

        public void handleStep(FieldODEStateInterpolator<T> interpolator) {
            this.handler.handleStep(new FieldAdaptedStepInterpolator(interpolator));
        }

        public void finish(FieldODEStateAndDerivative<T> finalState) {
            this.handler.finish(FieldAbstractIntegratedPropagator.this.convert(finalState));
        }
    }

    private class FieldAdaptedEventDetector
    implements FieldODEEventHandler<T> {
        private final FieldEventDetector<T> detector;
        private T lastT;
        private T lastG;

        FieldAdaptedEventDetector(FieldEventDetector<T> detector) {
            this.detector = detector;
            this.lastT = (CalculusFieldElement)((CalculusFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
            this.lastG = (CalculusFieldElement)((CalculusFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            this.detector.init(FieldAbstractIntegratedPropagator.this.convert(s0), FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
            this.lastT = (CalculusFieldElement)((CalculusFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
            this.lastG = (CalculusFieldElement)((CalculusFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
        }

        public T g(FieldODEStateAndDerivative<T> s) {
            if (!Precision.equals((double)this.lastT.getReal(), (double)s.getTime().getReal(), (int)0)) {
                this.lastT = s.getTime();
                this.lastG = this.detector.g(FieldAbstractIntegratedPropagator.this.convert(s));
            }
            return this.lastG;
        }

        public Action eventOccurred(FieldODEStateAndDerivative<T> s, boolean increasing) {
            return this.detector.eventOccurred(FieldAbstractIntegratedPropagator.this.convert(s), increasing);
        }

        public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> s) {
            FieldSpacecraftState oldState = FieldAbstractIntegratedPropagator.this.convert(s);
            FieldSpacecraftState newState = this.detector.resetState(oldState);
            FieldAbstractIntegratedPropagator.this.stateChanged(newState);
            CalculusFieldElement[] primary = (CalculusFieldElement[])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)s.getPrimaryStateDimension());
            FieldAbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, primary, null);
            CalculusFieldElement[][] secondary = (CalculusFieldElement[][])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)1, (int)FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders.size());
            for (FieldAdditionalDerivativesProvider provider : FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                String name = provider.getName();
                int offset = (Integer)FieldAbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                System.arraycopy(newState.getAdditionalState(name), 0, secondary[0], offset, dimension);
            }
            return new FieldODEState(newState.getDate().durationFrom(FieldAbstractIntegratedPropagator.this.getStartDate()), primary, secondary);
        }
    }

    private class ConvertedSecondaryStateEquations
    implements FieldSecondaryODE<T> {
        private final int combinedDimension;

        ConvertedSecondaryStateEquations() {
            this.combinedDimension = (Integer)FieldAbstractIntegratedPropagator.this.secondaryOffsets.get(FieldAbstractIntegratedPropagator.SECONDARY_DIMENSION);
        }

        public int getDimension() {
            return this.combinedDimension;
        }

        public void init(T t0, T[] primary0, T[] secondary0, T finalTime) {
            FieldSpacecraftState initialState = this.convert((CalculusFieldElement)t0, (CalculusFieldElement[])primary0, null, (CalculusFieldElement[])secondary0);
            FieldAbsoluteDate target = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            for (FieldAdditionalDerivativesProvider provider : FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                provider.init(initialState, target);
            }
        }

        public T[] computeDerivatives(T t, T[] primary, T[] primaryDot, T[] secondary) {
            FieldSpacecraftState updated = this.convert((CalculusFieldElement)t, (CalculusFieldElement[])primary, (CalculusFieldElement[])primaryDot, (CalculusFieldElement[])secondary);
            LinkedList<FieldAdditionalDerivativesProvider> pending = new LinkedList<FieldAdditionalDerivativesProvider>(FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders);
            CalculusFieldElement[] secondaryDot = (CalculusFieldElement[])MathArrays.buildArray((Field)t.getField(), (int)this.combinedDimension);
            int yieldCount = 0;
            while (!pending.isEmpty()) {
                FieldAdditionalDerivativesProvider equations = (FieldAdditionalDerivativesProvider)pending.remove();
                if (equations.yield(updated)) {
                    pending.add(equations);
                    if (++yieldCount < pending.size()) continue;
                    break;
                }
                String name = equations.getName();
                int offset = (Integer)FieldAbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = equations.getDimension();
                FieldCombinedDerivatives derivatives = equations.combinedDerivatives(updated);
                CalculusFieldElement[] additionalPart = derivatives.getAdditionalDerivatives();
                CalculusFieldElement[] mainPart = derivatives.getMainStateDerivativesIncrements();
                System.arraycopy(additionalPart, 0, secondaryDot, offset, dimension);
                updated = updated.addAdditionalStateDerivative(name, additionalPart);
                if (mainPart != null) {
                    for (int i = 0; i < mainPart.length; ++i) {
                        primaryDot[i] = (CalculusFieldElement)primaryDot[i].add((FieldElement)mainPart[i]);
                    }
                }
                yieldCount = 0;
            }
            return secondaryDot;
        }

        private FieldSpacecraftState<T> convert(T t, T[] primary, T[] primaryDot, T[] secondary) {
            FieldSpacecraftState initialState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((CalculusFieldElement)t, (CalculusFieldElement[])primary, (CalculusFieldElement[])primaryDot, PropagationType.MEAN);
            for (FieldAdditionalDerivativesProvider provider : FieldAbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                String name = provider.getName();
                int offset = (Integer)FieldAbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                initialState = initialState.addAdditionalState(name, (CalculusFieldElement[])Arrays.copyOfRange(secondary, offset, offset + dimension));
            }
            return FieldAbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
        }
    }

    private class ConvertedMainStateEquations
    implements FieldOrdinaryDifferentialEquation<T> {
        private final MainStateEquations<T> main;

        ConvertedMainStateEquations(MainStateEquations<T> main) {
            this.main = main;
            FieldAbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return FieldAbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void init(T t0, T[] y0, T finalTime) {
            FieldSpacecraftState initialState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((CalculusFieldElement)t0, (CalculusFieldElement[])y0, null, PropagationType.MEAN);
            initialState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
            FieldAbsoluteDate target = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            this.main.init(initialState, target);
        }

        public T[] computeDerivatives(T t, T[] y) {
            ++FieldAbstractIntegratedPropagator.this.calls;
            FieldSpacecraftState currentState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((CalculusFieldElement)t, (CalculusFieldElement[])y, null, PropagationType.MEAN);
            currentState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
            return this.main.computeDerivatives(currentState);
        }
    }

    public static interface MainStateEquations<T extends CalculusFieldElement<T>> {
        public void init(FieldSpacecraftState<T> var1, FieldAbsoluteDate<T> var2);

        public T[] computeDerivatives(FieldSpacecraftState<T> var1);
    }
}

