/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Frame;
import org.orekit.geometry.fov.FieldOfView;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.VisibilityTrigger;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class GroundFieldOfViewDetector
extends AbstractDetector<GroundFieldOfViewDetector> {
    private final Frame frame;
    private final FieldOfView fov;

    public GroundFieldOfViewDetector(Frame frame, FieldOfView fov) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), frame, fov);
    }

    private GroundFieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GroundFieldOfViewDetector> handler, Frame frame, FieldOfView fov) {
        super(maxCheck, threshold, maxIter, handler);
        this.frame = frame;
        this.fov = fov;
    }

    @Override
    protected GroundFieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GroundFieldOfViewDetector> newHandler) {
        return new GroundFieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.frame, this.fov);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public FieldOfView getFOV() {
        return this.fov;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D los = s.getPVCoordinates(this.frame).getPosition();
        return this.fov.offsetFromBoundary(los, 0.0, VisibilityTrigger.VISIBLE_ONLY_WHEN_FULLY_IN_FOV);
    }
}

