/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanModel;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.analytical.BrouwerLyddanePropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class BrouwerLyddanePropagatorBuilder
extends AbstractPropagatorBuilder
implements OrbitDeterminationPropagatorBuilder {
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-32);
    private final UnnormalizedSphericalHarmonicsProvider provider;

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle, double positionScale, double M2) {
        this(templateOrbit, provider, positionAngle, positionScale, InertialProvider.of(templateOrbit.getFrame()), M2);
    }

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, double referenceRadius, double mu, TideSystem tideSystem, double c20, double c30, double c40, double c50, OrbitType orbitType, PositionAngle positionAngle, double positionScale, double M2) {
        this(templateOrbit, GravityFieldFactory.getUnnormalizedProvider(referenceRadius, mu, tideSystem, new double[][]{{0.0}, {0.0}, {c20}, {c30}, {c40}, {c50}}, new double[][]{{0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}}), positionAngle, positionScale, M2);
    }

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle, double positionScale, AttitudeProvider attitudeProvider, double M2) {
        super(BrouwerLyddanePropagatorBuilder.overrideMu(templateOrbit, provider, positionAngle), positionAngle, positionScale, true, attitudeProvider);
        this.provider = provider;
        ParameterDriver M2Driver = new ParameterDriver("M2", M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.addSupportedParameter(M2Driver);
    }

    private static Orbit overrideMu(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle) {
        double[] parameters = new double[6];
        double[] parametersDot = templateOrbit.hasDerivatives() ? new double[6] : null;
        templateOrbit.getType().mapOrbitToArray(templateOrbit, positionAngle, parameters, parametersDot);
        return templateOrbit.getType().mapArrayToOrbit(parameters, parametersDot, positionAngle, templateOrbit.getDate(), provider.getMu(), templateOrbit.getFrame());
    }

    @Override
    public BrouwerLyddanePropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        double newM2 = 0.0;
        boolean isSelected = false;
        for (ParameterDriver parameterDriver : this.getPropagationParametersDrivers().getDrivers()) {
            if (!"M2".equals(parameterDriver.getName())) continue;
            newM2 = parameterDriver.getValue();
            isSelected = parameterDriver.isSelected();
        }
        BrouwerLyddanePropagator propagator = new BrouwerLyddanePropagator(this.createInitialOrbit(), this.getAttitudeProvider(), this.provider, newM2);
        propagator.getParametersDrivers().get(0).setSelected(isSelected);
        return propagator;
    }

    @Override
    public AbstractBatchLSModel buildLSModel(OrbitDeterminationPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }

    @Override
    public AbstractKalmanModel buildKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        return new KalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, measurementProcessNoiseMatrix);
    }
}

