/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.data.CommonLineReader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class DtcDataLoader
implements DataLoader {
    private static final Pattern PATTERN_SPACE = Pattern.compile("\\s+");
    private final TimeScale utc;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private SortedSet<LineParameters> set;

    public DtcDataLoader(TimeScale utc) {
        this.utc = utc;
        this.firstDate = null;
        this.lastDate = null;
        this.set = new TreeSet<TimeStamped>(new ChronologicalComparator());
    }

    public SortedSet<LineParameters> getDataSet() {
        return this.set;
    }

    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int lineNumber = 0;
        String line = null;
        int nHours = 24;
        HashSet<AbsoluteDate> parsedEpochs = new HashSet<AbsoluteDate>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            CommonLineReader reader = new CommonLineReader(br);
            line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                if (!reader.isEmptyLine()) {
                    String[] splitLine = PATTERN_SPACE.split(line);
                    int year = Integer.parseInt(splitLine[1]);
                    int dayYear = Integer.parseInt(splitLine[2]);
                    AbsoluteDate initDate = new AbsoluteDate(year, 1, 1, this.utc);
                    AbsoluteDate currDate = initDate.shiftedBy((double)(dayYear - 1) * 86400.0);
                    for (int i = 0; i < 24; ++i) {
                        AbsoluteDate date = currDate.shiftedBy(3600 * i);
                        if (!parsedEpochs.add(date)) continue;
                        double dtc = Integer.parseInt(splitLine[3 + i]);
                        this.set.add(new LineParameters(date, dtc));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        try {
            this.firstDate = this.set.first().getDate();
            this.lastDate = this.set.last().getDate();
        }
        catch (NoSuchElementException nse) {
            throw new OrekitException(nse, OrekitMessages.NO_DATA_IN_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    public static class LineParameters
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 8239275953453087629L;
        private final AbsoluteDate date;
        private final double dtc;

        public LineParameters(AbsoluteDate date, double dtc) {
            this.date = date;
            this.dtc = dtc;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getDSTDTC() {
            return this.dtc;
        }
    }
}

