/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;

public enum TimeSystem {
    GPS("GPS"),
    GLONASS("GLO"),
    GALILEO("GAL"),
    TAI("TAI"),
    UTC("UTC"),
    QZSS("QZS"),
    BEIDOU("BDS"),
    IRNSS("IRN"),
    UNKNOWN("LCL");

    private static final Map<String, TimeSystem> KEYS_MAP;
    private final String key;

    private TimeSystem(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static TimeSystem parseTimeSystem(String s) throws OrekitIllegalArgumentException {
        TimeSystem timeSystem = KEYS_MAP.get(s);
        if (timeSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_TIME_SYSTEM, s);
        }
        return timeSystem;
    }

    public TimeScale getTimeScale(TimeScales timeScales) {
        TimeScale timeScale = null;
        switch (this) {
            case GPS: {
                timeScale = timeScales.getGPS();
                break;
            }
            case GALILEO: {
                timeScale = timeScales.getGST();
                break;
            }
            case GLONASS: {
                timeScale = timeScales.getGLONASS();
                break;
            }
            case QZSS: {
                timeScale = timeScales.getQZSS();
                break;
            }
            case TAI: {
                timeScale = timeScales.getTAI();
                break;
            }
            case UTC: {
                timeScale = timeScales.getUTC();
                break;
            }
            case BEIDOU: {
                timeScale = timeScales.getBDT();
                break;
            }
            case IRNSS: {
                timeScale = timeScales.getIRNSS();
                break;
            }
            default: {
                timeScale = timeScales.getGPS();
            }
        }
        return timeScale;
    }

    static {
        KEYS_MAP = new HashMap<String, TimeSystem>();
        for (TimeSystem timeSystem : TimeSystem.values()) {
            KEYS_MAP.put(timeSystem.getKey(), timeSystem);
        }
    }
}

