/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public interface StaticTransform
extends TimeStamped {
    public static StaticTransform getIdentity() {
        return Transform.IDENTITY;
    }

    default public Vector3D transformPosition(Vector3D position) {
        return this.getRotation().applyTo(this.getTranslation().add((Vector)position));
    }

    default public <T extends CalculusFieldElement<T>> FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
        return FieldRotation.applyTo((Rotation)this.getRotation(), (FieldVector3D)position.add(this.getTranslation()));
    }

    default public Vector3D transformVector(Vector3D vector) {
        return this.getRotation().applyTo(vector);
    }

    default public <T extends CalculusFieldElement<T>> FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
        return FieldRotation.applyTo((Rotation)this.getRotation(), vector);
    }

    default public Line transformLine(Line line) {
        Vector3D transformedP0 = this.transformPosition(line.getOrigin());
        Vector3D transformedD = this.transformVector(line.getDirection());
        return Line.fromDirection((Vector3D)transformedP0, (Vector3D)transformedD, (double)line.getTolerance());
    }

    public Vector3D getTranslation();

    public Rotation getRotation();

    public StaticTransform getInverse();

    public static StaticTransform compose(AbsoluteDate date, StaticTransform first, StaticTransform second) {
        return StaticTransform.of(date, StaticTransform.compositeTranslation(first, second), StaticTransform.compositeRotation(first, second));
    }

    public static Vector3D compositeTranslation(StaticTransform first, StaticTransform second) {
        Vector3D p1 = first.getTranslation();
        Rotation r1 = first.getRotation();
        Vector3D p2 = second.getTranslation();
        return p1.add((Vector)r1.applyInverseTo(p2));
    }

    public static Rotation compositeRotation(StaticTransform first, StaticTransform second) {
        Rotation r1 = first.getRotation();
        Rotation r2 = second.getRotation();
        return r1.compose(r2, RotationConvention.FRAME_TRANSFORM);
    }

    public static StaticTransform of(AbsoluteDate date, Rotation rotation) {
        return StaticTransform.of(date, Vector3D.ZERO, rotation);
    }

    public static StaticTransform of(AbsoluteDate date, Vector3D translation) {
        return StaticTransform.of(date, translation, Rotation.IDENTITY);
    }

    public static StaticTransform of(final AbsoluteDate date, final Vector3D translation, final Rotation rotation) {
        return new StaticTransform(){

            @Override
            public StaticTransform getInverse() {
                Rotation r = this.getRotation();
                Vector3D rp = r.applyTo(this.getTranslation());
                Vector3D pInv = rp.negate();
                return StaticTransform.of(date, pInv, rotation.revert());
            }

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public Vector3D getTranslation() {
                return translation;
            }

            @Override
            public Rotation getRotation() {
                return rotation;
            }
        };
    }
}

