/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SingleBodyRelativeAttraction
extends AbstractForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmDriver;
    private final CelestialBody body;

    public SingleBodyRelativeAttraction(CelestialBody body) {
        this.gmDriver = new ParameterDriver(body.getName() + ATTRACTION_COEFFICIENT_SUFFIX, body.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.body = body;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        TimeStampedPVCoordinates bodyPV = this.body.getPVCoordinates(s.getDate(), s.getFrame());
        Vector3D satToBody = bodyPV.getPosition().subtract((Vector)s.getPVCoordinates().getPosition());
        double r2Sat = satToBody.getNormSq();
        double gm = parameters[0];
        double a = gm / r2Sat;
        return new Vector3D(a, satToBody.normalize()).add((Vector)bodyPV.getAcceleration());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        TimeStampedFieldPVCoordinates<T> bodyPV = this.body.getPVCoordinates(s.getDate(), s.getFrame());
        FieldVector3D satToBody = bodyPV.getPosition().subtract(s.getPVCoordinates().getPosition());
        CalculusFieldElement r2Sat = satToBody.getNormSq();
        T gm = parameters[0];
        CalculusFieldElement a = (CalculusFieldElement)gm.divide((FieldElement)r2Sat);
        return new FieldVector3D(a, satToBody.normalize()).add(bodyPV.getAcceleration());
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmDriver);
    }
}

