/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.utils.ParameterDriver;

public class NewtonianAttraction
extends AbstractForceModel {
    public static final String CENTRAL_ATTRACTION_COEFFICIENT = "central attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver gmParameterDriver;

    public NewtonianAttraction(double mu) {
        this.gmParameterDriver = new ParameterDriver(CENTRAL_ATTRACTION_COEFFICIENT, mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }

    public double getMu() {
        return this.gmParameterDriver.getValue();
    }

    public <T extends CalculusFieldElement<T>> T getMu(Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        return (T)((CalculusFieldElement)zero.add(this.gmParameterDriver.getValue()));
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        adder.addKeplerContribution(this.getMu());
    }

    @Override
    public <T extends CalculusFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        Field<T> field = s.getDate().getField();
        adder.addKeplerContribution(this.getMu(field));
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double mu = parameters[0];
        double r2 = s.getPVCoordinates().getPosition().getNormSq();
        return new Vector3D(-mu / (FastMath.sqrt((double)r2) * r2), s.getPVCoordinates().getPosition());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        T mu = parameters[0];
        CalculusFieldElement r2 = s.getPVCoordinates().getPosition().getNormSq();
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.sqrt()).multiply((FieldElement)r2)).reciprocal()).multiply(mu)).negate(), s.getPVCoordinates().getPosition());
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }
}

