/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.AbstractForceModel;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class AbstractDragForceModel
extends AbstractForceModel {
    private final Atmosphere atmosphere;

    protected AbstractDragForceModel(Atmosphere atmosphere) {
        this.atmosphere = atmosphere;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    protected <T extends CalculusFieldElement<T>> boolean isDSStateDerivative(FieldSpacecraftState<T> state) {
        try {
            DerivativeStructure dsMass = (DerivativeStructure)state.getMass();
            int o = dsMass.getOrder();
            int p = dsMass.getFreeParameters();
            if (o != 1 || p != 6 && p != 7 && p != 8) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((DerivativeStructure)pv.getPosition().getX(), 0) && this.isVariable((DerivativeStructure)pv.getPosition().getY(), 1) && this.isVariable((DerivativeStructure)pv.getPosition().getZ(), 2) && this.isVariable((DerivativeStructure)pv.getVelocity().getX(), 3) && this.isVariable((DerivativeStructure)pv.getVelocity().getY(), 4) && this.isVariable((DerivativeStructure)pv.getVelocity().getZ(), 5);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    protected <T extends CalculusFieldElement<T>> boolean isGradientStateDerivative(FieldSpacecraftState<T> state) {
        try {
            Gradient gMass = (Gradient)state.getMass();
            int p = gMass.getFreeParameters();
            if (p != 6 && p != 7 && p != 8) {
                return false;
            }
            TimeStampedFieldPVCoordinates<T> pv = state.getPVCoordinates();
            return this.isVariable((Gradient)pv.getPosition().getX(), 0) && this.isVariable((Gradient)pv.getPosition().getY(), 1) && this.isVariable((Gradient)pv.getPosition().getZ(), 2) && this.isVariable((Gradient)pv.getVelocity().getX(), 3) && this.isVariable((Gradient)pv.getVelocity().getY(), 4) && this.isVariable((Gradient)pv.getVelocity().getZ(), 5);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    protected boolean isVariable(DerivativeStructure ds, int index) {
        double[] derivatives = ds.getAllDerivatives();
        boolean check = true;
        for (int i = 1; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index + 1 == i ? 1.0 : 0.0);
        }
        return check;
    }

    protected boolean isVariable(Gradient g, int index) {
        double[] derivatives = g.getGradient();
        boolean check = true;
        for (int i = 0; i < derivatives.length; ++i) {
            check &= derivatives[i] == (index == i ? 1.0 : 0.0);
        }
        return check;
    }

    protected DerivativeStructure getDSDensityWrtStateUsingFiniteDifferences(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position) {
        DSFactory factory = ((DerivativeStructure)position.getX()).getFactory();
        DSFactory factory3 = new DSFactory(3, 1);
        FieldVector3D position3 = new FieldVector3D((CalculusFieldElement)factory3.variable(0, ((DerivativeStructure)position.getX()).getReal()), (CalculusFieldElement)factory3.variable(1, ((DerivativeStructure)position.getY()).getReal()), (CalculusFieldElement)factory3.variable(2, ((DerivativeStructure)position.getZ()).getReal()));
        Frame atmFrame = this.atmosphere.getFrame();
        StaticTransform toBody = frame.getStaticTransformTo(atmFrame, date);
        FieldVector3D posBodyDS = toBody.transformPosition(position3);
        Vector3D posBody = posBodyDS.toVector3D();
        double delta = 1.0;
        double x = posBody.getX();
        double y = posBody.getY();
        double z = posBody.getZ();
        double rho0 = this.atmosphere.getDensity(date, posBody, atmFrame);
        double dRhodX = (this.atmosphere.getDensity(date, new Vector3D(x + 1.0, y, z), atmFrame) - rho0) / 1.0;
        double dRhodY = (this.atmosphere.getDensity(date, new Vector3D(x, y + 1.0, z), atmFrame) - rho0) / 1.0;
        double dRhodZ = (this.atmosphere.getDensity(date, new Vector3D(x, y, z + 1.0), atmFrame) - rho0) / 1.0;
        double[] dXdQ = ((DerivativeStructure)posBodyDS.getX()).getAllDerivatives();
        double[] dYdQ = ((DerivativeStructure)posBodyDS.getY()).getAllDerivatives();
        double[] dZdQ = ((DerivativeStructure)posBodyDS.getZ()).getAllDerivatives();
        int p = factory.getCompiler().getFreeParameters();
        double[] rhoAll = new double[p + 1];
        rhoAll[0] = rho0;
        for (int i = 1; i < 4; ++i) {
            rhoAll[i] = dRhodX * dXdQ[i] + dRhodY * dYdQ[i] + dRhodZ * dZdQ[i];
        }
        return factory.build(rhoAll);
    }

    protected Gradient getGradientDensityWrtStateUsingFiniteDifferences(AbsoluteDate date, Frame frame, FieldVector3D<Gradient> position) {
        FieldVector3D position3 = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)3, (int)0, (double)((Gradient)position.getX()).getReal()), (CalculusFieldElement)Gradient.variable((int)3, (int)1, (double)((Gradient)position.getY()).getReal()), (CalculusFieldElement)Gradient.variable((int)3, (int)2, (double)((Gradient)position.getZ()).getReal()));
        Frame atmFrame = this.atmosphere.getFrame();
        StaticTransform toBody = frame.getStaticTransformTo(atmFrame, date);
        FieldVector3D posBodyDS = toBody.transformPosition(position3);
        Vector3D posBody = posBodyDS.toVector3D();
        double delta = 1.0;
        double x = posBody.getX();
        double y = posBody.getY();
        double z = posBody.getZ();
        double rho0 = this.atmosphere.getDensity(date, posBody, atmFrame);
        double dRhodX = (this.atmosphere.getDensity(date, new Vector3D(x + 1.0, y, z), atmFrame) - rho0) / 1.0;
        double dRhodY = (this.atmosphere.getDensity(date, new Vector3D(x, y + 1.0, z), atmFrame) - rho0) / 1.0;
        double dRhodZ = (this.atmosphere.getDensity(date, new Vector3D(x, y, z + 1.0), atmFrame) - rho0) / 1.0;
        double[] dXdQ = ((Gradient)posBodyDS.getX()).getGradient();
        double[] dYdQ = ((Gradient)posBodyDS.getY()).getGradient();
        double[] dZdQ = ((Gradient)posBodyDS.getZ()).getGradient();
        int p = ((Gradient)position.getX()).getFreeParameters();
        double[] rhoAll = new double[p];
        for (int i = 0; i < 3; ++i) {
            rhoAll[i] = dRhodX * dXdQ[i] + dRhodY * dYdQ[i] + dRhodZ * dZdQ[i];
        }
        return new Gradient(rho0, rhoAll);
    }
}

