/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.sinex.SinexEopEntry;
import org.orekit.files.sinex.Station;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.ITRFVersion;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

public class SinexLoader
implements EOPHistoryLoader {
    private static final String LOD = "LOD";
    private static final String UT = "UT";
    private static final String XPO = "XPO";
    private static final String YPO = "YPO";
    private static final String NUT_LN = "NUT_LN";
    private static final String NUT_OB = "NUT_OB";
    private static final String NUT_X = "NUT_X";
    private static final String NUT_Y = "NUT_Y";
    private static final String DEFAULT_EPOCH = "00:000:00000";
    private static final Pattern SEPARATOR = Pattern.compile(":");
    private static final Pattern PATTERN_SPACE = Pattern.compile("\\s+");
    private static final Pattern PATTERN_BEGIN = Pattern.compile("(%=).*");
    private static final List<String> EOP_TYPES = Arrays.asList("LOD", "UT", "XPO", "YPO", "NUT_LN", "NUT_OB", "NUT_X", "NUT_Y");
    private AbsoluteDate startDate;
    private AbsoluteDate endDate;
    private final Map<String, Station> stations;
    private Map<AbsoluteDate, SinexEopEntry> map;
    private ITRFVersion itrfVersionEop;
    private final TimeScale utc;

    @DefaultDataContext
    public SinexLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public SinexLoader(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this.utc = utc;
        this.stations = new HashMap<String, Station>();
        this.itrfVersionEop = ITRFVersion.ITRF_2014;
        this.map = new HashMap<AbsoluteDate, SinexEopEntry>();
        dataProvidersManager.feed(supportedNames, new Parser());
    }

    @DefaultDataContext
    public SinexLoader(DataSource source) {
        this(source, DataContext.getDefault().getTimeScales().getUTC());
    }

    public SinexLoader(DataSource source, TimeScale utc) {
        try {
            this.utc = utc;
            this.stations = new HashMap<String, Station>();
            this.itrfVersionEop = ITRFVersion.ITRF_2014;
            this.map = new HashMap<AbsoluteDate, SinexEopEntry>();
            try (InputStream is = source.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                new Parser().loadData(bis, source.getName());
            }
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    public void setITRFVersion(int year) {
        this.itrfVersionEop = ITRFVersion.getITRFVersion(year);
    }

    public ITRFVersion getITRFVersion() {
        return this.itrfVersionEop;
    }

    public Map<String, Station> getStations() {
        return Collections.unmodifiableMap(this.stations);
    }

    public Map<AbsoluteDate, SinexEopEntry> getParsedEop() {
        return Collections.unmodifiableMap(this.map);
    }

    public Station getStation(String siteCode) {
        return this.stations.get(siteCode);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        history.addAll(this.getEopList(converter));
    }

    private AbsoluteDate stringEpochToAbsoluteDate(String stringDate) {
        if (DEFAULT_EPOCH.equals(stringDate)) {
            return AbsoluteDate.FUTURE_INFINITY;
        }
        String[] fields = SEPARATOR.split(stringDate);
        int twoDigitsYear = Integer.parseInt(fields[0]);
        int day = Integer.parseInt(fields[1]);
        int secInDay = Integer.parseInt(fields[2]);
        int year = twoDigitsYear > 50 ? 1900 + twoDigitsYear : 2000 + twoDigitsYear;
        return new AbsoluteDate(new DateComponents(year, 1, 1), this.utc).shiftedBy(86400.0 * (double)(day - 1)).shiftedBy(secInDay);
    }

    private void addStation(Station station) {
        if (this.stations.get(station.getSiteCode()) == null) {
            this.stations.put(station.getSiteCode(), station);
        }
    }

    private SinexEopEntry getSinexEopEntry(AbsoluteDate date) {
        this.map.putIfAbsent(date, new SinexEopEntry(date));
        return this.map.get(date);
    }

    private List<EOPEntry> getEopList(IERSConventions.NutationCorrectionConverter converter) {
        ArrayList<EOPEntry> eop = new ArrayList<EOPEntry>();
        SortedSet<SinexEopEntry> set = this.mapToSortedSet(this.map);
        for (SinexEopEntry entry : set) {
            eop.add(entry.toEopEntry(converter, this.itrfVersionEop, this.utc));
        }
        eop.add(this.copyEopEntry(this.startDate, set.first()).toEopEntry(converter, this.itrfVersionEop, this.utc));
        eop.add(this.copyEopEntry(this.endDate, set.last()).toEopEntry(converter, this.itrfVersionEop, this.utc));
        eop.sort(new ChronologicalComparator());
        return eop;
    }

    private <T extends TimeStamped> SortedSet<T> mapToSortedSet(Map<AbsoluteDate, T> inputMap) {
        TreeSet<TimeStamped> set = new TreeSet<TimeStamped>(new ChronologicalComparator());
        for (Map.Entry<AbsoluteDate, T> entry : inputMap.entrySet()) {
            set.add((TimeStamped)entry.getValue());
        }
        return set;
    }

    private SinexEopEntry copyEopEntry(AbsoluteDate date, SinexEopEntry reference) {
        SinexEopEntry newEntry = new SinexEopEntry(date);
        newEntry.setLod(reference.getLod());
        newEntry.setUt1MinusUtc(reference.getUt1MinusUtc());
        newEntry.setxPo(reference.getXPo());
        newEntry.setyPo(reference.getYPo());
        newEntry.setNutX(reference.getNutX());
        newEntry.setNutY(reference.getNutY());
        newEntry.setNutLn(reference.getNutLn());
        newEntry.setNutOb(reference.getNutOb());
        return newEntry;
    }

    private class Parser
    implements DataLoader {
        private static final String COMMENT = "*";

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            int lineNumber = 0;
            String line = null;
            boolean inId = false;
            boolean inEcc = false;
            boolean inEpoch = false;
            boolean inEstimate = false;
            boolean firstEcc = true;
            Vector3D position = Vector3D.ZERO;
            Vector3D velocity = Vector3D.ZERO;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                line = reader.readLine();
                while (line != null) {
                    if (++lineNumber == 1 && PATTERN_BEGIN.matcher(line).matches()) {
                        String[] splitFirstLine = PATTERN_SPACE.split(line);
                        AbsoluteDate fileStartDate = SinexLoader.this.stringEpochToAbsoluteDate(splitFirstLine[5]);
                        AbsoluteDate fileEndDate = SinexLoader.this.stringEpochToAbsoluteDate(splitFirstLine[6]);
                        if (SinexLoader.this.startDate == null) {
                            SinexLoader.this.startDate = fileStartDate;
                            SinexLoader.this.endDate = fileEndDate;
                        }
                        SinexLoader.this.startDate = fileStartDate.isBefore(SinexLoader.this.startDate) ? fileStartDate : SinexLoader.this.startDate;
                        SinexLoader.this.endDate = fileEndDate.isAfter(SinexLoader.this.endDate) ? fileEndDate : SinexLoader.this.endDate;
                    }
                    block13 : switch (line.trim()) {
                        case "+SITE/ID": {
                            inId = true;
                            break;
                        }
                        case "-SITE/ID": {
                            inId = false;
                            break;
                        }
                        case "+SITE/ECCENTRICITY": {
                            inEcc = true;
                            break;
                        }
                        case "-SITE/ECCENTRICITY": {
                            inEcc = false;
                            break;
                        }
                        case "+SOLUTION/EPOCHS": {
                            inEpoch = true;
                            break;
                        }
                        case "-SOLUTION/EPOCHS": {
                            inEpoch = false;
                            break;
                        }
                        case "+SOLUTION/ESTIMATE": {
                            inEstimate = true;
                            break;
                        }
                        case "-SOLUTION/ESTIMATE": {
                            inEstimate = false;
                            break;
                        }
                        default: {
                            Station station;
                            if (line.startsWith(COMMENT)) break;
                            if (inId) {
                                station = new Station();
                                station.setSiteCode(this.parseString(line, 1, 4));
                                station.setDomes(this.parseString(line, 9, 9));
                                SinexLoader.this.addStation(station);
                                break;
                            }
                            if (inEcc) {
                                station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                if (station.getEccentricitiesTimeSpanMap().getSpansNumber() == 1) {
                                    firstEcc = true;
                                }
                                AbsoluteDate start = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12));
                                AbsoluteDate end = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12));
                                station.setEccRefSystem(Station.ReferenceSystem.getEccRefSystem(this.parseString(line, 42, 3)));
                                Vector3D eccStation = new Vector3D(this.parseDouble(line, 46, 8), this.parseDouble(line, 55, 8), this.parseDouble(line, 64, 8));
                                if (firstEcc) {
                                    station.addStationEccentricitiesValidBefore(eccStation, end);
                                    station.addStationEccentricitiesValidBefore(null, start);
                                    firstEcc = false;
                                } else {
                                    station.addStationEccentricitiesValidBefore(eccStation, end);
                                }
                                station.setEccentricities(eccStation);
                                break;
                            }
                            if (inEpoch) {
                                station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                station.setValidFrom(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12)));
                                station.setValidUntil(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12)));
                                break;
                            }
                            if (!inEstimate) break;
                            station = SinexLoader.this.getStation(this.parseString(line, 14, 4));
                            AbsoluteDate currentDate = SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 27, 12));
                            String dataType = this.parseString(line, 7, 6);
                            if (station == null && !EOP_TYPES.contains(dataType)) break;
                            switch (dataType) {
                                case "STAX": {
                                    double x = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(x, position.getY(), position.getZ());
                                    station.setPosition(position);
                                    break block13;
                                }
                                case "STAY": {
                                    double y = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(position.getX(), y, position.getZ());
                                    station.setPosition(position);
                                    break block13;
                                }
                                case "STAZ": {
                                    double z = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(position.getX(), position.getY(), z);
                                    station.setPosition(position);
                                    station.setEpoch(currentDate);
                                    position = Vector3D.ZERO;
                                    break block13;
                                }
                                case "VELX": {
                                    double vx = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(vx, velocity.getY(), velocity.getZ());
                                    station.setVelocity(velocity);
                                    break block13;
                                }
                                case "VELY": {
                                    double vy = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(velocity.getX(), vy, velocity.getZ());
                                    station.setVelocity(velocity);
                                    break block13;
                                }
                                case "VELZ": {
                                    double vz = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(velocity.getX(), velocity.getY(), vz);
                                    station.setVelocity(velocity);
                                    velocity = Vector3D.ZERO;
                                    break block13;
                                }
                                case "XPO": {
                                    double xPo = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setxPo(xPo);
                                    break block13;
                                }
                                case "YPO": {
                                    double yPo = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setyPo(yPo);
                                    break block13;
                                }
                                case "LOD": {
                                    double lod = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setLod(lod);
                                    break block13;
                                }
                                case "UT": {
                                    double dt = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setUt1MinusUtc(dt);
                                    break block13;
                                }
                                case "NUT_LN": {
                                    double nutLn = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setNutLn(nutLn);
                                    break block13;
                                }
                                case "NUT_OB": {
                                    double nutOb = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setNutOb(nutOb);
                                    break block13;
                                }
                                case "NUT_X": {
                                    double nutX = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setNutX(nutX);
                                    break block13;
                                }
                                case "NUT_Y": {
                                    double nutY = this.parseDoubleWithUnit(line, 40, 4, 47, 21);
                                    SinexLoader.this.getSinexEopEntry(currentDate).setNutY(nutY);
                                    break block13;
                                }
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
        }

        private String parseString(String line, int start, int length) {
            return line.substring(start, FastMath.min((int)line.length(), (int)(start + length))).trim();
        }

        private double parseDouble(String line, int start, int length) {
            return Double.parseDouble(this.parseString(line, start, length));
        }

        private double parseDoubleWithUnit(String line, int startUnit, int lengthUnit, int startDouble, int lengthDouble) {
            Unit unit = Unit.parse(this.parseString(line, startUnit, lengthUnit));
            return unit.toSI(this.parseDouble(line, startDouble, lengthDouble));
        }
    }
}

