/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.HeaderKey;
import org.orekit.time.AbsoluteDate;

public class Header
extends CommentsContainer {
    private double formatVersion = Double.NaN;
    private AbsoluteDate creationDate;
    private String originator;
    private String messageId;
    private final double minVersionMessageId;

    public Header(double minVersionMessageId) {
        this.minVersionMessageId = minVersionMessageId;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.creationDate, HeaderKey.CREATION_DATE);
        this.checkNotNull(this.originator, HeaderKey.ORIGINATOR);
        this.checkAllowed(version, this.messageId, HeaderKey.MESSAGE_ID, this.minVersionMessageId, Double.POSITIVE_INFINITY);
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.refuseFurtherComments();
        this.creationDate = creationDate;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.refuseFurtherComments();
        this.originator = originator;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }
}

