/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.io.IOException;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.OemWriter;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class StreamingOemWriter
implements AutoCloseable {
    private final Generator generator;
    private final OemWriter writer;
    private final Header header;
    private final OemMetadata metadata;
    private final boolean useAttitudeFrame;
    private final boolean includeAcceleration;
    private boolean headerWritePending;

    public StreamingOemWriter(Generator generator, OemWriter writer, Header header, OemMetadata template) {
        this(generator, writer, header, template, true);
    }

    public StreamingOemWriter(Generator generator, OemWriter writer, Header header, OemMetadata template, boolean useAttitudeFrame) {
        this(generator, writer, header, template, useAttitudeFrame, true);
    }

    public StreamingOemWriter(Generator generator, OemWriter writer, Header header, OemMetadata template, boolean useAttitudeFrame, boolean includeAcceleration) {
        this.generator = generator;
        this.writer = writer;
        this.header = header;
        this.metadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.useAttitudeFrame = useAttitudeFrame;
        this.includeAcceleration = includeAcceleration;
        this.headerWritePending = true;
    }

    public SegmentWriter newSegment() {
        return new SegmentWriter();
    }

    @Override
    public void close() throws IOException {
        this.writer.writeFooter(this.generator);
    }

    public class SegmentWriter
    implements OrekitFixedStepHandler {
        private Frame frame;

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t, double step) {
            try {
                AbsoluteDate date = s0.getDate();
                if (t.isBefore(date)) {
                    throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICALLY_SORTED_ENTRIES, date, t, date.durationFrom(t));
                }
                if (StreamingOemWriter.this.headerWritePending) {
                    StreamingOemWriter.this.writer.writeHeader(StreamingOemWriter.this.generator, StreamingOemWriter.this.header);
                    StreamingOemWriter.this.headerWritePending = false;
                }
                StreamingOemWriter.this.metadata.setStartTime(date);
                StreamingOemWriter.this.metadata.setUseableStartTime(null);
                StreamingOemWriter.this.metadata.setUseableStopTime(null);
                StreamingOemWriter.this.metadata.setStopTime(t);
                if (StreamingOemWriter.this.useAttitudeFrame) {
                    this.frame = s0.getAttitude().getReferenceFrame();
                    StreamingOemWriter.this.metadata.setReferenceFrame(FrameFacade.map(this.frame));
                } else {
                    this.frame = StreamingOemWriter.this.metadata.getFrame();
                }
                StreamingOemWriter.this.writer.writeMetadata(StreamingOemWriter.this.generator, StreamingOemWriter.this.metadata);
                StreamingOemWriter.this.writer.startData(StreamingOemWriter.this.generator);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void handleStep(SpacecraftState currentState) {
            try {
                TimeStampedPVCoordinates pv = currentState.getPVCoordinates(this.frame);
                StreamingOemWriter.this.writer.writeOrbitEphemerisLine(StreamingOemWriter.this.generator, StreamingOemWriter.this.metadata, pv, StreamingOemWriter.this.includeAcceleration);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void finish(SpacecraftState finalState) {
            try {
                StreamingOemWriter.this.writer.endData(StreamingOemWriter.this.generator);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }
    }
}

