/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmParser;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.ocm.Covariance;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverFieldType;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Ocm;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmData;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDetermination;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDeterminationKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Perturbations;
import org.orekit.files.ccsds.ndm.odm.ocm.PerturbationsKey;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalProperties;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalPropertiesKey;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadataKey;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.UserDefinedXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

public class OcmParser
extends OdmParser<Ocm, OcmParser>
implements EphemerisFileParser<Ocm> {
    private static final Pattern SPLIT_AT_BLANKS = Pattern.compile("\\s+");
    private Header header;
    private OcmMetadata metadata;
    private ContextBinding context;
    private List<TrajectoryStateHistory> trajectoryBlocks;
    private TrajectoryStateHistoryMetadata currentTrajectoryStateHistoryMetadata;
    private List<TrajectoryState> currentTrajectoryStateHistory;
    private PhysicalProperties physicBlock;
    private List<CovarianceHistory> covarianceBlocks;
    private CovarianceHistoryMetadata currentCovarianceHistoryMetadata;
    private List<Covariance> currentCovarianceHistory;
    private List<ManeuverHistory> maneuverBlocks;
    private ManeuverHistoryMetadata currentManeuverHistoryMetadata;
    private List<Maneuver> currentManeuverHistory;
    private Perturbations perturbationsBlock;
    private OrbitDetermination orbitDeterminationBlock;
    private UserDefined userDefinedBlock;
    private ProcessingState structureProcessor;

    public OcmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, double mu, ParsedUnitsBehavior parsedUnitsBehavior) {
        super("ocm", "CCSDS_OCM_VERS", conventions, simpleEOP, dataContext, null, mu, parsedUnitsBehavior);
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.put("USER_DEFINED", new UserDefinedXmlTokenBuilder());
        return builders;
    }

    @Override
    public Ocm parse(DataSource source) {
        return (Ocm)this.parseMessage(source);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new Header(3.0);
        this.metadata = null;
        this.context = null;
        this.trajectoryBlocks = null;
        this.physicBlock = null;
        this.covarianceBlocks = null;
        this.maneuverBlocks = null;
        this.perturbationsBlock = null;
        this.orbitDeterminationBlock = null;
        this.userDefinedBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("ocm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new OcmMetadata(this.getDataContext());
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this.metadata::getEpochT0, this.metadata::getTimeSystem, this.metadata::getSclkOffsetAtEpoch, this.metadata::getSclkSecPerSISec);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        this.anticipateNext(this::processDataSubStructureToken);
        return true;
    }

    @Override
    public boolean prepareData() {
        this.anticipateNext(this::processDataSubStructureToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        List<TrajectoryStateHistory> old = this.trajectoryBlocks;
        if (old != null) {
            this.trajectoryBlocks = new ArrayList<TrajectoryStateHistory>(old.size());
            for (TrajectoryStateHistory osh : old) {
                this.trajectoryBlocks.add(new TrajectoryStateHistory(osh.getMetadata(), osh.getTrajectoryStates(), this.getSelectedMu()));
            }
        }
        return true;
    }

    boolean manageTrajectoryStateSection(boolean starting) {
        if (starting) {
            if (this.trajectoryBlocks == null) {
                this.trajectoryBlocks = new ArrayList<TrajectoryStateHistory>();
            }
            this.currentTrajectoryStateHistoryMetadata = new TrajectoryStateHistoryMetadata(this.metadata.getEpochT0(), this.getDataContext());
            this.currentTrajectoryStateHistory = new ArrayList<TrajectoryState>();
            this.anticipateNext(this::processTrajectoryStateToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            if (this.currentTrajectoryStateHistoryMetadata.getCenter().getBody() != null) {
                this.setMuCreated(this.currentTrajectoryStateHistoryMetadata.getCenter().getBody().getGM());
            }
            this.trajectoryBlocks.add(new TrajectoryStateHistory(this.currentTrajectoryStateHistoryMetadata, this.currentTrajectoryStateHistory, Double.NaN));
        }
        return true;
    }

    boolean managePhysicalPropertiesSection(boolean starting) {
        if (starting) {
            if (this.physicBlock == null) {
                this.physicBlock = new PhysicalProperties(this.metadata.getEpochT0());
            }
            this.anticipateNext(this::processPhysicalPropertyToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageCovarianceHistorySection(boolean starting) {
        if (starting) {
            if (this.covarianceBlocks == null) {
                this.covarianceBlocks = new ArrayList<CovarianceHistory>();
            }
            this.currentCovarianceHistoryMetadata = new CovarianceHistoryMetadata(this.metadata.getEpochT0());
            this.currentCovarianceHistory = new ArrayList<Covariance>();
            this.anticipateNext(this::processCovarianceToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            this.covarianceBlocks.add(new CovarianceHistory(this.currentCovarianceHistoryMetadata, this.currentCovarianceHistory));
            this.currentCovarianceHistoryMetadata = null;
            this.currentCovarianceHistory = null;
        }
        return true;
    }

    boolean manageManeuversSection(boolean starting) {
        if (starting) {
            if (this.maneuverBlocks == null) {
                this.maneuverBlocks = new ArrayList<ManeuverHistory>();
            }
            this.currentManeuverHistoryMetadata = new ManeuverHistoryMetadata(this.metadata.getEpochT0());
            this.currentManeuverHistory = new ArrayList<Maneuver>();
            this.anticipateNext(this::processManeuverToken);
        } else {
            this.anticipateNext(this.structureProcessor);
            this.maneuverBlocks.add(new ManeuverHistory(this.currentManeuverHistoryMetadata, this.currentManeuverHistory));
            this.currentManeuverHistoryMetadata = null;
            this.currentManeuverHistory = null;
        }
        return true;
    }

    boolean managePerturbationParametersSection(boolean starting) {
        if (starting) {
            if (this.perturbationsBlock == null) {
                this.perturbationsBlock = new Perturbations(this.context.getDataContext().getCelestialBodies());
            }
            this.anticipateNext(this::processPerturbationToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageOrbitDeterminationSection(boolean starting) {
        if (starting) {
            if (this.orbitDeterminationBlock == null) {
                this.orbitDeterminationBlock = new OrbitDetermination();
            }
            this.anticipateNext(this::processOrbitDeterminationToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageUserDefinedParametersSection(boolean starting) {
        if (starting) {
            if (this.userDefinedBlock == null) {
                this.userDefinedBlock = new UserDefined();
            }
            this.anticipateNext(this::processUserDefinedToken);
        } else {
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    @Override
    public Ocm build() {
        this.finalizeData();
        if (this.userDefinedBlock != null && this.userDefinedBlock.getParameters().isEmpty()) {
            this.userDefinedBlock = null;
        }
        if (this.perturbationsBlock != null) {
            this.setMuParsed(this.perturbationsBlock.getGm());
        }
        OcmData data = new OcmData(this.trajectoryBlocks, this.physicBlock, this.covarianceBlocks, this.maneuverBlocks, this.perturbationsBlock, this.orbitDeterminationBlock, this.userDefinedBlock);
        data.validate(this.header.getFormatVersion());
        return new Ocm(this.header, Collections.singletonList(new Segment<OcmMetadata, OcmData>(this.metadata, data)), this.getConventions(), this.getDataContext(), this.getSelectedMu());
    }

    private boolean processMetadataToken(ParseToken token) {
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return OdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return OcmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    return false;
                }
            }
        }
    }

    private boolean processDataSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && OcmDataSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processTrajectoryStateToken(ParseToken token) {
        if (token.getName() != null && !token.getName().equals("trajLine")) {
            try {
                return TrajectoryStateHistoryMetadataKey.valueOf(token.getName()).process(token, this.context, this.currentTrajectoryStateHistoryMetadata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        if (this.currentTrajectoryStateHistory.isEmpty()) {
            this.currentTrajectoryStateHistoryMetadata.validate(this.header.getFormatVersion());
            this.anticipateNext(this::processDataSubStructureToken);
        }
        if (token.getType() == TokenType.START || token.getType() == TokenType.STOP) {
            return true;
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
            List<Unit> units = this.currentTrajectoryStateHistoryMetadata.getTrajType().getUnits();
            if (fields.length != units.size() + 1) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
            }
            AbsoluteDate epoch = this.context.getTimeSystem().getConverter(this.context).parse(fields[0]);
            return this.currentTrajectoryStateHistory.add(new TrajectoryState(this.currentTrajectoryStateHistoryMetadata.getTrajType(), epoch, fields, 1, units));
        }
        catch (NumberFormatException | OrekitIllegalArgumentException e) {
            throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processPhysicalPropertyToken(ParseToken token) {
        if (this.physicBlock == null) {
            this.physicBlock = new PhysicalProperties(this.metadata.getEpochT0());
        }
        this.anticipateNext(this::processDataSubStructureToken);
        try {
            return token.getName() != null && PhysicalPropertiesKey.valueOf(token.getName()).process(token, this.context, this.physicBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processCovarianceToken(ParseToken token) {
        if (token.getName() != null && !token.getName().equals("covLine")) {
            try {
                return CovarianceHistoryMetadataKey.valueOf(token.getName()).process(token, this.context, this.currentCovarianceHistoryMetadata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        if (this.currentCovarianceHistory.isEmpty()) {
            this.currentCovarianceHistoryMetadata.validate(this.header.getFormatVersion());
            this.anticipateNext(this::processDataSubStructureToken);
        }
        if (token.getType() == TokenType.START || token.getType() == TokenType.STOP) {
            return true;
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
            int n = this.currentCovarianceHistoryMetadata.getCovUnits().size();
            if (fields.length - 1 != this.currentCovarianceHistoryMetadata.getCovOrdering().nbElements(n)) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
            }
            this.currentCovarianceHistory.add(new Covariance(this.currentCovarianceHistoryMetadata.getCovType(), this.currentCovarianceHistoryMetadata.getCovOrdering(), this.context.getTimeSystem().getConverter(this.context).parse(fields[0]), fields, 1));
            return true;
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processManeuverToken(ParseToken token) {
        if (token.getName() != null && !token.getName().equals("manLine")) {
            try {
                return ManeuverHistoryMetadataKey.valueOf(token.getName()).process(token, this.context, this.currentManeuverHistoryMetadata);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        if (this.currentManeuverHistory.isEmpty()) {
            this.currentManeuverHistoryMetadata.validate(this.header.getFormatVersion());
            this.anticipateNext(this::processDataSubStructureToken);
        }
        if (token.getType() == TokenType.START || token.getType() == TokenType.STOP) {
            return true;
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
            List<ManeuverFieldType> types = this.currentManeuverHistoryMetadata.getManComposition();
            if (fields.length != types.size()) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
            }
            Maneuver maneuver = new Maneuver();
            for (int i = 0; i < fields.length; ++i) {
                types.get(i).process(fields[i], this.context, maneuver, token.getLineNumber(), token.getFileName());
            }
            this.currentManeuverHistory.add(maneuver);
            return true;
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processPerturbationToken(ParseToken token) {
        this.anticipateNext(this::processDataSubStructureToken);
        try {
            return token.getName() != null && PerturbationsKey.valueOf(token.getName()).process(token, this.context, this.perturbationsBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processOrbitDeterminationToken(ParseToken token) {
        if (this.orbitDeterminationBlock == null) {
            this.orbitDeterminationBlock = new OrbitDetermination();
        }
        this.anticipateNext(this::processDataSubStructureToken);
        try {
            return token.getName() != null && OrbitDeterminationKey.valueOf(token.getName()).process(token, this.context, this.orbitDeterminationBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processUserDefinedToken(ParseToken token) {
        if (this.userDefinedBlock == null) {
            this.userDefinedBlock = new UserDefined();
        }
        this.anticipateNext(this::processDataSubStructureToken);
        if ("COMMENT".equals(token.getName())) {
            return token.getType() == TokenType.ENTRY ? this.userDefinedBlock.addComment(token.getContentAsNormalizedString()) : true;
        }
        if (token.getName().startsWith("USER_DEFINED_")) {
            if (token.getType() == TokenType.ENTRY) {
                this.userDefinedBlock.addEntry(token.getName().substring("USER_DEFINED_".length()), token.getContentAsNormalizedString());
            }
            return true;
        }
        return false;
    }
}

