/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.cdm.StateVector;
import org.orekit.files.ccsds.ndm.cdm.StateVectorKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

public class StateVectorWriter
extends AbstractWriter {
    private final StateVector stateVector;

    StateVectorWriter(String xmlTag, String kvnTag, StateVector StateVector2) {
        super(xmlTag, kvnTag);
        this.stateVector = StateVector2;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.stateVector.getComments());
        generator.writeEntry(StateVectorKey.X.name(), this.stateVector.getPositionVector().getX(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.Y.name(), this.stateVector.getPositionVector().getY(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.Z.name(), this.stateVector.getPositionVector().getZ(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.X_DOT.name(), this.stateVector.getVelocityVector().getX(), Units.KM_PER_S, true);
        generator.writeEntry(StateVectorKey.Y_DOT.name(), this.stateVector.getVelocityVector().getY(), Units.KM_PER_S, true);
        generator.writeEntry(StateVectorKey.Z_DOT.name(), this.stateVector.getVelocityVector().getZ(), Units.KM_PER_S, true);
    }
}

