/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class ModifierGradientConverter
extends AbstractGradientConverter {
    public ModifierGradientConverter(SpacecraftState state, int freeStateParameters, AttitudeProvider provider) {
        super(freeStateParameters);
        GradientField field = GradientField.getField((int)freeStateParameters);
        Vector3D pos = state.getPVCoordinates().getPosition();
        FieldVector3D posG = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)0, (double)pos.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)1, (double)pos.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)2, (double)pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velG = freeStateParameters > 3 ? new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)3, (double)vel.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)4, (double)vel.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)5, (double)vel.getZ())) : new FieldVector3D((CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getX()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getY()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getZ()));
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accG = new FieldVector3D((CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getX()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getY()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getZ()));
        Gradient dsM = Gradient.constant((int)freeStateParameters, (double)state.getMass());
        FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates(state.getDate(), posG, velG, accG), state.getFrame(), ((Gradient)field.getZero()).add(state.getMu()));
        FieldAttitude<Object> gAttitude = freeStateParameters > 3 ? provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame()) : new FieldAttitude(field, state.getAttitude());
        this.initStates(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, dsM));
    }
}

