/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.BistaticRange;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.modifiers.BaseRangeIonosphericDelayModifier;
import org.orekit.estimation.measurements.modifiers.BistaticModifierUtil;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.SpacecraftState;

public class BistaticRangeIonosphericDelayModifier
extends BaseRangeIonosphericDelayModifier
implements EstimationModifier<BistaticRange> {
    public BistaticRangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        super(model, freq);
    }

    @Override
    public void modify(EstimatedMeasurement<BistaticRange> estimated) {
        BistaticRange measurement = estimated.getObservedMeasurement();
        GroundStation emitter = measurement.getEmitterStation();
        GroundStation receiver = measurement.getReceiverStation();
        SpacecraftState state = estimated.getStates()[0];
        BistaticModifierUtil.modify(estimated, this.getIonoModel(), new ModifierGradientConverter(state, 6, new InertialProvider(state.getFrame())), emitter, receiver, this::rangeErrorIonosphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, rangeErrorIonosphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((BistaticRangeIonosphericDelayModifier)this));
    }
}

