/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffect;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParametersDriversProvider;

class BistaticModifierUtil {
    private BistaticModifierUtil() {
    }

    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParametersDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation emitter, GroundStation receiver, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient) {
        double parameterDerivative;
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        FieldSpacecraftState<Gradient> gState = converter.getState(parametricModel);
        Gradient[] gParameters = converter.getParameters(gState, parametricModel);
        Gradient delayUp = modelEffectGradient.evaluate(emitter, gState, gParameters);
        double[] derivativesUp = delayUp.getGradient();
        Gradient delayDown = modelEffectGradient.evaluate(receiver, gState, gParameters);
        double[] derivativesDown = delayDown.getGradient();
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
            double[] dArray = stateDerivatives[0];
            int n = jcol;
            dArray[n] = dArray[n] + derivativesUp[jcol];
            double[] dArray2 = stateDerivatives[0];
            int n2 = jcol;
            dArray2[n2] = dArray2[n2] + derivativesDown[jcol];
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            parameterDerivative += derivativesUp[index + converter.getFreeStateParameters()];
            estimated.setParameterDerivatives(driver, parameterDerivative += derivativesDown[index + converter.getFreeStateParameters()]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(emitter.getEastOffsetDriver(), emitter.getNorthOffsetDriver(), emitter.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += Differentiation.differentiate(d -> modelEffect.evaluate(emitter, state), 3, 10.0 * driver.getScale()).value(driver));
        }
        for (ParameterDriver driver : Arrays.asList(receiver.getClockOffsetDriver(), receiver.getEastOffsetDriver(), receiver.getNorthOffsetDriver(), receiver.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += Differentiation.differentiate(d -> modelEffect.evaluate(receiver, state), 3, 10.0 * driver.getScale()).value(driver));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + delayUp.getValue();
        newValue[0] = newValue[0] + delayDown.getValue();
        estimated.setEstimatedValue(newValue);
    }
}

