/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public abstract class BaseRangeTroposphericDelayModifier {
    private final DiscreteTroposphericModel tropoModel;

    protected BaseRangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    protected DiscreteTroposphericModel getTropoModel() {
        return this.tropoModel;
    }

    public double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double delay = this.tropoModel.pathDelay(elevation, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            return delay;
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T rangeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation.getReal() > 0.0) {
            CalculusFieldElement delay = this.tropoModel.pathDelay((CalculusFieldElement)elevation, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            return (T)delay;
        }
        return (T)zero;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }
}

