/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AbstractRelativisticJ2ClockModifier {
    private final double cJ2;
    private final double gm;

    public AbstractRelativisticJ2ClockModifier(double gm, double c20, double equatorialRadius) {
        this.cJ2 = 1.5 * c20 * equatorialRadius * equatorialRadius / 8.987551787368176E16;
        this.gm = gm;
    }

    protected double relativisticJ2Correction(EstimatedMeasurement<?> estimated) {
        SpacecraftState[] states = estimated.getStates();
        SpacecraftState state = states.length < 2 ? states[0] : states[1];
        Frame remoteFrame = state.getFrame();
        TimeStampedPVCoordinates[] pvs = estimated.getParticipants();
        TimeStampedPVCoordinates pvRemote = pvs.length < 3 ? pvs[0] : pvs[1];
        KeplerianOrbit remoteOrbit = new KeplerianOrbit(pvRemote, remoteFrame, this.gm);
        double orbitInclination = remoteOrbit.getI();
        double orbitU = remoteOrbit.getTrueAnomaly() + remoteOrbit.getPerigeeArgument();
        double n = remoteOrbit.getKeplerianMeanMotion();
        return this.cJ2 * n * FastMath.sin((double)(2.0 * orbitU)) * FastMath.sin((double)orbitInclination) * FastMath.sin((double)orbitInclination);
    }
}

