/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.BistaticRangeRate;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class BistaticRangeRateBuilder
extends AbstractMeasurementBuilder<BistaticRangeRate> {
    private final GroundStation emitter;
    private final GroundStation receiver;

    public BistaticRangeRateBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation emitter, GroundStation receiver, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.emitter = emitter;
        this.receiver = receiver;
    }

    @Override
    public BistaticRangeRate build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{states[satellite.getPropagatorIndex()]};
        BistaticRangeRate dummy = new BistaticRangeRate(this.emitter, this.receiver, relevant[0].getDate(), Double.NaN, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double brr = dummy.estimate(0, 0, relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            brr += noise[0];
        }
        BistaticRangeRate measurement = new BistaticRangeRate(this.emitter, this.receiver, relevant[0].getDate(), brr, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

