/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TDOA
extends AbstractMeasurement<TDOA> {
    private final GroundStation primeStation;
    private final GroundStation secondStation;

    public TDOA(GroundStation primeStation, GroundStation secondStation, AbsoluteDate date, double tdoa, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, tdoa, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(primeStation.getClockOffsetDriver());
        this.addParameterDriver(primeStation.getEastOffsetDriver());
        this.addParameterDriver(primeStation.getNorthOffsetDriver());
        this.addParameterDriver(primeStation.getZenithOffsetDriver());
        this.addParameterDriver(primeStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(primeStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(primeStation.getPolarOffsetXDriver());
        this.addParameterDriver(primeStation.getPolarDriftXDriver());
        this.addParameterDriver(primeStation.getPolarOffsetYDriver());
        this.addParameterDriver(primeStation.getPolarDriftYDriver());
        this.addParameterDriver(secondStation.getClockOffsetDriver());
        this.addParameterDriver(secondStation.getEastOffsetDriver());
        this.addParameterDriver(secondStation.getNorthOffsetDriver());
        this.addParameterDriver(secondStation.getZenithOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(secondStation.getPolarOffsetXDriver());
        this.addParameterDriver(secondStation.getPolarDriftXDriver());
        this.addParameterDriver(secondStation.getPolarOffsetYDriver());
        this.addParameterDriver(secondStation.getPolarDriftYDriver());
        this.primeStation = primeStation;
        this.secondStation = secondStation;
    }

    public GroundStation getPrimeStation() {
        return this.primeStation;
    }

    public GroundStation getSecondStation() {
        return this.secondStation;
    }

    @Override
    protected EstimatedMeasurement<TDOA> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        TimeStampedFieldPVCoordinates<Gradient> secondPV;
        double delta;
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || indices.containsKey(driver.getName())) continue;
            indices.put(driver.getName(), nbParams++);
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pvaG = TDOA.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> primeToInert = this.primeStation.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> measurementDateG = primeToInert.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> primePV = primeToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(measurementDateG, zero, zero, zero));
        Gradient tau1 = TDOA.signalTimeOfFlight(pvaG, primePV.getPosition(), measurementDateG);
        Gradient dtMtau1 = measurementDateG.durationFrom(state.getDate()).subtract(tau1);
        SpacecraftState emitterState = state.shiftedBy(dtMtau1.getValue());
        FieldPVCoordinates emitterPV = pvaG.shiftedBy((CalculusFieldElement)dtMtau1);
        Gradient tau2 = tau1;
        int count = 0;
        do {
            double previous = tau2.getValue();
            AbsoluteDate dateAt2 = emitterState.getDate().shiftedBy(previous);
            FieldTransform<Gradient> secondToInert = this.secondStation.getOffsetToInertial(state.getFrame(), dateAt2, nbParams, indices);
            secondPV = secondToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(secondToInert.getFieldDate(), zero, zero, zero));
            tau2 = this.linkDelay(emitterPV.getPosition(), secondPV.getPosition());
            delta = FastMath.abs((double)(tau2.getValue() - previous));
        } while (count++ < 10 && delta >= 2.0 * FastMath.ulp((double)tau2.getValue()));
        Gradient offset1 = this.primeStation.getClockOffsetDriver().getValue(nbParams, indices);
        Gradient offset2 = this.secondStation.getClockOffsetDriver().getValue(nbParams, indices);
        Gradient tdoaG = tau1.add(offset1).subtract(tau2.add(offset2));
        double tdoa = tdoaG.getValue();
        TimeStampedPVCoordinates pv1 = primePV.toTimeStampedPVCoordinates();
        TimeStampedPVCoordinates pv2 = secondPV.toTimeStampedPVCoordinates();
        EstimatedMeasurement<TDOA> estimated = new EstimatedMeasurement<TDOA>(this, iteration, evaluation, new SpacecraftState[]{emitterState}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)emitterPV).toTimeStampedPVCoordinates(), tdoa > 0.0 ? pv2 : pv1, tdoa > 0.0 ? pv1 : pv2});
        estimated.setEstimatedValue(tdoa);
        double[] derivatives = tdoaG.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }

    private Gradient linkDelay(FieldVector3D<Gradient> emitter, FieldVector3D<Gradient> receiver) {
        return ((Gradient)receiver.distance(emitter)).divide(2.99792458E8);
    }
}

