/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BistaticRangeRate
extends AbstractMeasurement<BistaticRangeRate> {
    private final GroundStation emitter;
    private final GroundStation receiver;

    public BistaticRangeRate(GroundStation emitter, GroundStation receiver, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, rangeRate, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(emitter.getEastOffsetDriver());
        this.addParameterDriver(emitter.getNorthOffsetDriver());
        this.addParameterDriver(emitter.getZenithOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianDriftDriver());
        this.addParameterDriver(emitter.getPolarOffsetXDriver());
        this.addParameterDriver(emitter.getPolarDriftXDriver());
        this.addParameterDriver(emitter.getPolarOffsetYDriver());
        this.addParameterDriver(emitter.getPolarDriftYDriver());
        this.addParameterDriver(receiver.getClockOffsetDriver());
        this.addParameterDriver(receiver.getEastOffsetDriver());
        this.addParameterDriver(receiver.getNorthOffsetDriver());
        this.addParameterDriver(receiver.getZenithOffsetDriver());
        this.addParameterDriver(receiver.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(receiver.getPrimeMeridianDriftDriver());
        this.addParameterDriver(receiver.getPolarOffsetXDriver());
        this.addParameterDriver(receiver.getPolarDriftXDriver());
        this.addParameterDriver(receiver.getPolarOffsetYDriver());
        this.addParameterDriver(receiver.getPolarDriftYDriver());
        this.emitter = emitter;
        this.receiver = receiver;
    }

    public GroundStation getEmitterStation() {
        return this.emitter;
    }

    public GroundStation getReceiverStation() {
        return this.receiver;
    }

    @Override
    protected EstimatedMeasurement<BistaticRangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver2 : this.getParametersDrivers()) {
            if (!driver2.isSelected() || indices.containsKey(driver2.getName())) continue;
            indices.put(driver2.getName(), nbParams++);
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pvaG = BistaticRangeRate.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> receiverToInertial = this.receiver.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> measurementDateG = receiverToInertial.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> receiverPV = receiverToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(measurementDateG, zero, zero, zero));
        Gradient tauD = BistaticRangeRate.signalTimeOfFlight(pvaG, receiverPV.getPosition(), measurementDateG);
        Gradient delta = measurementDateG.durationFrom(state.getDate());
        Gradient deltaMTauD = delta.subtract(tauD);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitPV = pvaG.shiftedBy((CalculusFieldElement)deltaMTauD);
        EstimatedMeasurement<BistaticRangeRate> evalDownlink = this.oneWayTheoreticalEvaluation(iteration, evaluation, true, receiverPV, (TimeStampedFieldPVCoordinates<Gradient>)transitPV, transitState, indices);
        FieldTransform<Gradient> emitterToInertial = this.emitter.getOffsetToInertial(state.getFrame(), ((TimeStampedFieldPVCoordinates)transitPV).getDate(), nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> emitterPV = emitterToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates(((TimeStampedFieldPVCoordinates)transitPV).getDate(), zero, zero, zero));
        Gradient tauU = BistaticRangeRate.signalTimeOfFlight(emitterPV, transitPV.getPosition(), ((TimeStampedFieldPVCoordinates)transitPV).getDate());
        FieldPVCoordinates emitterUplink = emitterPV.shiftedBy((CalculusFieldElement)tauU.negate());
        EstimatedMeasurement<BistaticRangeRate> evalUplink = this.oneWayTheoreticalEvaluation(iteration, evaluation, false, (TimeStampedFieldPVCoordinates<Gradient>)emitterUplink, (TimeStampedFieldPVCoordinates<Gradient>)transitPV, transitState, indices);
        EstimatedMeasurement<BistaticRangeRate> estimated = new EstimatedMeasurement<BistaticRangeRate>(this, iteration, evaluation, evalDownlink.getStates(), new TimeStampedPVCoordinates[]{evalUplink.getParticipants()[0], evalDownlink.getParticipants()[0], evalDownlink.getParticipants()[1]});
        estimated.setEstimatedValue(evalDownlink.getEstimatedValue()[0] + evalUplink.getEstimatedValue()[0]);
        double[][] sd1 = evalDownlink.getStateDerivatives(0);
        double[][] sd2 = evalUplink.getStateDerivatives(0);
        double[][] sd = new double[sd1.length][sd1[0].length];
        for (int i = 0; i < sd.length; ++i) {
            for (int j = 0; j < sd[0].length; ++j) {
                sd[i][j] = sd1[i][j] + sd2[i][j];
            }
        }
        estimated.setStateDerivatives(0, sd);
        evalDownlink.getDerivativesDrivers().forEach(driver -> {
            double[] pd1 = evalDownlink.getParameterDerivatives((ParameterDriver)driver);
            double[] pd2 = evalUplink.getParameterDerivatives((ParameterDriver)driver);
            double[] pd = new double[pd1.length];
            for (int i = 0; i < pd.length; ++i) {
                pd[i] = pd1[i] + pd2[i];
            }
            estimated.setParameterDerivatives((ParameterDriver)driver, pd);
        });
        return estimated;
    }

    private EstimatedMeasurement<BistaticRangeRate> oneWayTheoreticalEvaluation(int iteration, int evaluation, boolean downlink, TimeStampedFieldPVCoordinates<Gradient> stationPV, TimeStampedFieldPVCoordinates<Gradient> transitPV, SpacecraftState transitState, Map<String, Integer> indices) {
        EstimatedMeasurement<BistaticRangeRate> estimated = new EstimatedMeasurement<BistaticRangeRate>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{(downlink ? transitPV : stationPV).toTimeStampedPVCoordinates(), (downlink ? stationPV : transitPV).toTimeStampedPVCoordinates()});
        FieldVector3D stationPosition = stationPV.getPosition();
        FieldVector3D relativePosition = stationPosition.subtract(transitPV.getPosition());
        FieldVector3D stationVelocity = stationPV.getVelocity();
        FieldVector3D relativeVelocity = stationVelocity.subtract(transitPV.getVelocity());
        FieldVector3D lineOfSight = relativePosition.normalize();
        Gradient rangeRate = (Gradient)FieldVector3D.dotProduct((FieldVector3D)relativeVelocity, (FieldVector3D)lineOfSight);
        estimated.setEstimatedValue(rangeRate.getValue());
        double[] derivatives = rangeRate.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }
}

