/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.orekit.bodies.LazyLoadedCelestialBodies;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.forces.gravity.potential.LazyLoadedGravityFields;
import org.orekit.frames.Frame;
import org.orekit.frames.LazyLoadedEop;
import org.orekit.frames.LazyLoadedFrames;
import org.orekit.models.earth.LazyLoadedGeoMagneticFields;
import org.orekit.time.LazyLoadedTimeScales;

public class LazyLoadedDataContext
implements DataContext {
    private final DataProvidersManager dataProvidersManager = new DataProvidersManager();
    private final LazyLoadedEop eop = new LazyLoadedEop(this.dataProvidersManager);
    private final LazyLoadedTimeScales timeScales = new LazyLoadedTimeScales(this.eop);
    private LazyLoadedFrames frames;
    private LazyLoadedCelestialBodies bodies;
    private final LazyLoadedGravityFields gravityFields = new LazyLoadedGravityFields(this.dataProvidersManager, this.timeScales.getTT());
    private final LazyLoadedGeoMagneticFields geoMagneticFields = new LazyLoadedGeoMagneticFields(this.dataProvidersManager);

    public DataProvidersManager getDataProvidersManager() {
        return this.dataProvidersManager;
    }

    @Override
    public LazyLoadedTimeScales getTimeScales() {
        return this.timeScales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLoadedFrames getFrames() {
        LazyLoadedDataContext lazyLoadedDataContext = this;
        synchronized (lazyLoadedDataContext) {
            if (this.frames == null) {
                this.frames = new LazyLoadedFrames(this.eop, this.getTimeScales(), this.getCelestialBodies());
            }
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLoadedCelestialBodies getCelestialBodies() {
        LazyLoadedDataContext lazyLoadedDataContext = this;
        synchronized (lazyLoadedDataContext) {
            if (this.bodies == null) {
                Frame gcrf = Frame.getRoot();
                this.bodies = new LazyLoadedCelestialBodies(this.getDataProvidersManager(), this.getTimeScales(), gcrf);
            }
            return this.bodies;
        }
    }

    @Override
    public LazyLoadedGravityFields getGravityFields() {
        return this.gravityFields;
    }

    @Override
    public LazyLoadedGeoMagneticFields getGeoMagneticFields() {
        return this.geoMagneticFields;
    }
}

