/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.IAUPole;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class JPLCelestialBody
implements CelestialBody {
    private static final long serialVersionUID = 3809787672779740923L;
    private final String name;
    private final String supportedNames;
    private final JPLEphemeridesLoader.EphemerisType generateType;
    private final transient JPLEphemeridesLoader.RawPVProvider rawPVProvider;
    private final double gm;
    private final double scale;
    private final IAUPole iauPole;
    private final Frame inertialFrame;
    private final Frame bodyFrame;

    JPLCelestialBody(String name, String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, JPLEphemeridesLoader.RawPVProvider rawPVProvider, double gm, double scale, IAUPole iauPole, Frame definingFrameAlignedWithICRF, String inertialFrameName, String bodyOrientedFrameName) {
        this.name = name;
        this.gm = gm;
        this.scale = scale;
        this.supportedNames = supportedNames;
        this.generateType = generateType;
        this.rawPVProvider = rawPVProvider;
        this.iauPole = iauPole;
        this.inertialFrame = new InertiallyOriented(definingFrameAlignedWithICRF, inertialFrameName);
        this.bodyFrame = new BodyOriented(bodyOrientedFrameName);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        PVCoordinates rawPV = this.rawPVProvider.getRawPV(date);
        TimeStampedPVCoordinates scaledPV = new TimeStampedPVCoordinates(date, this.scale, rawPV);
        Transform transform = this.getInertiallyOrientedFrame().getParent().getTransformTo(frame, date);
        return transform.transformPVCoordinates(scaledPV);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        FieldPVCoordinates<T> rawPV = this.rawPVProvider.getRawPV(date);
        TimeStampedFieldPVCoordinates<double> scaledPV = new TimeStampedFieldPVCoordinates<double>((FieldAbsoluteDate<double>)date, this.scale, (FieldPVCoordinates<double>)rawPV);
        FieldTransform<double> transform = this.getInertiallyOrientedFrame().getParent().getTransformTo(frame, date);
        return transform.transformPVCoordinates(scaledPV);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DTOCelestialBody(this.supportedNames, this.generateType, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getGM() {
        return this.gm;
    }

    @Override
    public Frame getInertiallyOrientedFrame() {
        return this.inertialFrame;
    }

    @Override
    public Frame getBodyOrientedFrame() {
        return this.bodyFrame;
    }

    @DefaultDataContext
    private static class DTOBodyFrame
    extends DataTransferObject {
        private static final long serialVersionUID = -3194195019557081000L;

        DTOBodyFrame(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody().bodyFrame;
        }
    }

    @DefaultDataContext
    private static class DTOInertialFrame
    extends DataTransferObject {
        private static final long serialVersionUID = 7915071664444154948L;

        DTOInertialFrame(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody().inertialFrame;
        }
    }

    @DefaultDataContext
    private static class DTOCelestialBody
    extends DataTransferObject {
        private static final long serialVersionUID = -8287341529741045958L;

        DTOCelestialBody(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody();
        }
    }

    @DefaultDataContext
    private static abstract class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 674742836536072422L;
        private final String supportedNames;
        private final JPLEphemeridesLoader.EphemerisType generateType;
        private final String name;

        DataTransferObject(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            this.supportedNames = supportedNames;
            this.generateType = generateType;
            this.name = name;
        }

        protected JPLCelestialBody getBody() {
            try {
                JPLCelestialBody jplBody;
                CelestialBody factoryProvided = DataContext.getDefault().getCelestialBodies().getBody(this.name);
                if (factoryProvided instanceof JPLCelestialBody && this.supportedNames.equals((jplBody = (JPLCelestialBody)factoryProvided).supportedNames) && this.generateType == jplBody.generateType) {
                    return jplBody;
                }
                return (JPLCelestialBody)new JPLEphemeridesLoader(this.supportedNames, this.generateType).loadCelestialBody(this.name);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private class BodyOriented
    extends Frame {
        private static final long serialVersionUID = 20170109L;
        private static final String BODY_FRAME_SUFFIX = "/rotating";

        BodyOriented(String frameName) {
            super(JPLCelestialBody.this.inertialFrame, new TransformProvider(){
                private static final long serialVersionUID = 20170109L;

                @Override
                public Transform getTransform(AbsoluteDate date) {
                    double dt = 10.0;
                    double w0 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date);
                    double w1 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date.shiftedBy(10.0));
                    return new Transform(date, new Rotation(Vector3D.PLUS_K, w0, RotationConvention.FRAME_TRANSFORM), new Vector3D((w1 - w0) / 10.0, Vector3D.PLUS_K));
                }

                @Override
                public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
                    double dt = 10.0;
                    T w0 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date);
                    Object w1 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date.shiftedBy(10.0));
                    return new FieldTransform<T>(date, new FieldRotation(FieldVector3D.getPlusK(date.getField()), w0, RotationConvention.FRAME_TRANSFORM), new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)w1.subtract(w0)).divide(10.0), Vector3D.PLUS_K));
                }
            }, frameName == null ? JPLCelestialBody.this.name + BODY_FRAME_SUFFIX : frameName, false);
        }

        @DefaultDataContext
        private Object writeReplace() {
            return new DTOBodyFrame(JPLCelestialBody.this.supportedNames, JPLCelestialBody.this.generateType, JPLCelestialBody.this.name);
        }
    }

    private class InertiallyOriented
    extends Frame {
        private static final long serialVersionUID = -8849993808761896559L;
        private static final String INERTIAL_FRAME_SUFFIX = "/inertial";

        InertiallyOriented(final Frame definingFrame, String frameName) {
            super(definingFrame, new TransformProvider(){
                private static final long serialVersionUID = -8610328386110652400L;

                @Override
                public Transform getTransform(AbsoluteDate date) {
                    TimeStampedPVCoordinates pv = JPLCelestialBody.this.getPVCoordinates(date, definingFrame);
                    Transform translation = new Transform(date, pv.negate());
                    Vector3D pole = JPLCelestialBody.this.iauPole.getPole(date);
                    Vector3D qNode = JPLCelestialBody.this.iauPole.getNode(date);
                    Transform rotation = new Transform(date, new Rotation(pole, qNode, Vector3D.PLUS_K, Vector3D.PLUS_I));
                    return new Transform(date, translation, rotation);
                }

                @Override
                public StaticTransform getStaticTransform(AbsoluteDate date) {
                    TimeStampedPVCoordinates pv = JPLCelestialBody.this.getPVCoordinates(date, definingFrame);
                    Vector3D pole = JPLCelestialBody.this.iauPole.getPole(date);
                    Vector3D qNode = JPLCelestialBody.this.iauPole.getNode(date);
                    Rotation rotation = new Rotation(pole, qNode, Vector3D.PLUS_K, Vector3D.PLUS_I);
                    return StaticTransform.of(date, pv.getPosition().negate(), rotation);
                }

                @Override
                public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
                    TimeStampedFieldPVCoordinates<T> pv = JPLCelestialBody.this.getPVCoordinates(date, definingFrame);
                    FieldTransform<T> translation = new FieldTransform<T>(date, pv.negate());
                    FieldVector3D<T> pole = JPLCelestialBody.this.iauPole.getPole(date);
                    FieldVector3D qNode = FieldVector3D.crossProduct((Vector3D)Vector3D.PLUS_K, pole);
                    if (qNode.getNormSq().getReal() < Precision.SAFE_MIN) {
                        qNode = FieldVector3D.getPlusI(date.getField());
                    }
                    FieldTransform<T> rotation = new FieldTransform<T>(date, new FieldRotation(pole, qNode, FieldVector3D.getPlusK(date.getField()), FieldVector3D.getPlusI(date.getField())));
                    return new FieldTransform<T>(date, translation, rotation);
                }
            }, frameName == null ? JPLCelestialBody.this.name + INERTIAL_FRAME_SUFFIX : frameName, true);
        }

        @DefaultDataContext
        private Object writeReplace() {
            return new DTOInertialFrame(JPLCelestialBody.this.supportedNames, JPLCelestialBody.this.generateType, JPLCelestialBody.this.name);
        }
    }
}

