/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.events.FilterType;
import org.hipparchus.ode.events.Transformer;
import org.hipparchus.util.MathArrays;

public class FieldEventFilter<T extends CalculusFieldElement<T>>
implements FieldODEEventHandler<T> {
    private static final int HISTORY_SIZE = 100;
    private final FieldODEEventHandler<T> rawHandler;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final T[] updates;
    private boolean forward;
    private T extremeT;

    public FieldEventFilter(Field<T> field, FieldODEEventHandler<T> rawHandler, FilterType filter) {
        this.rawHandler = rawHandler;
        this.filter = filter;
        this.transformers = new Transformer[100];
        this.updates = (CalculusFieldElement[])MathArrays.buildArray(field, (int)100);
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> initialState, T finalTime) {
        this.rawHandler.init(initialState, finalTime);
        this.forward = finalTime.getReal() >= initialState.getTime().getReal();
        this.extremeT = (CalculusFieldElement)((CalculusFieldElement)finalTime.getField().getZero()).add(this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public T g(FieldODEStateAndDerivative<T> state) {
        T rawG = this.rawHandler.g(state);
        if (this.forward) {
            int last = this.transformers.length - 1;
            if (((CalculusFieldElement)this.extremeT.subtract(state.getTime())).getReal() < 0.0) {
                Transformer previous = this.transformers[last];
                Transformer next = this.filter.selectTransformer(previous, rawG.getReal(), this.forward);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = state.getTime();
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (!(((CalculusFieldElement)this.updates[i].subtract(state.getTime())).getReal() <= 0.0)) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (((CalculusFieldElement)state.getTime().subtract(this.extremeT)).getReal() < 0.0) {
            Transformer previous = this.transformers[0];
            Transformer next = this.filter.selectTransformer(previous, rawG.getReal(), this.forward);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = state.getTime();
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (!(((CalculusFieldElement)state.getTime().subtract(this.updates[i])).getReal() <= 0.0)) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    @Override
    public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
        return this.rawHandler.eventOccurred(state, this.filter.isTriggeredOnIncreasing());
    }

    @Override
    public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
        return this.rawHandler.resetState(state);
    }
}

