/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.Collection;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.events.EventHandlerConfiguration;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.ODEStepHandler;

public interface ODEIntegrator {
    public String getName();

    public void addStepHandler(ODEStepHandler var1);

    public Collection<ODEStepHandler> getStepHandlers();

    public void clearStepHandlers();

    public void addEventHandler(ODEEventHandler var1, double var2, double var4, int var6);

    public void addEventHandler(ODEEventHandler var1, double var2, double var4, int var6, BracketedUnivariateSolver<UnivariateFunction> var7);

    public Collection<ODEEventHandler> getEventHandlers();

    public Collection<EventHandlerConfiguration> getEventHandlersConfigurations();

    public void clearEventHandlers();

    public ODEStateAndDerivative getStepStart();

    public double getCurrentSignedStepsize();

    public void setMaxEvaluations(int var1);

    public int getMaxEvaluations();

    public int getEvaluations();

    public ODEStateAndDerivative integrate(ExpandableODE var1, ODEState var2, double var3) throws MathIllegalArgumentException, MathIllegalStateException;

    default public ODEStateAndDerivative integrate(OrdinaryDifferentialEquation equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.integrate(new ExpandableODE(equations), initialState, finalTime);
    }
}

