/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils.units;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.units.Prefix;
import org.orekit.utils.units.Unit;

class PrefixedUnit
extends Unit {
    private static final long serialVersionUID = 20210407L;
    private static final Map<String, PrefixedUnit> ALLOWED;

    PrefixedUnit(Prefix prefix, Unit unit) {
        super(prefix == null ? unit.getName() : prefix.getSymbol() + unit.getName(), prefix == null ? unit.getScale() : prefix.getFactor() * unit.getScale(), unit.getMass(), unit.getLength(), unit.getTime(), unit.getCurrent(), unit.getAngle());
    }

    public static PrefixedUnit valueOf(String name) {
        PrefixedUnit prefixedUnit = ALLOWED.get(name);
        if (prefixedUnit == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_UNIT, name);
        }
        return prefixedUnit;
    }

    static {
        List<Unit> base = Arrays.asList(Unit.SECOND, Unit.MINUTE, Unit.HOUR, Unit.DAY, Unit.DAY.alias("day"), Unit.YEAR, Unit.YEAR.alias("yr"), Unit.HERTZ, Unit.METRE, Unit.GRAM, Unit.AMPERE, Unit.RADIAN, Unit.DEGREE, Unit.DEGREE.alias("\u25e6"), Unit.DEGREE.alias("deg"), Unit.ARC_MINUTE, Unit.ARC_MINUTE.alias("'"), Unit.ARC_SECOND, Unit.ARC_SECOND.alias("''"), Unit.ARC_SECOND.alias("\""), Unit.ARC_SECOND.alias("as"), Unit.REVOLUTION, Unit.NEWTON, Unit.PASCAL, Unit.BAR, Unit.JOULE, Unit.WATT, Unit.COULOMB, Unit.VOLT, Unit.OHM, Unit.TESLA, Unit.SOLAR_FLUX_UNIT, Unit.SOLAR_FLUX_UNIT.alias("SFU"), Unit.SOLAR_FLUX_UNIT.alias("sfu"), Unit.TOTAL_ELECTRON_CONTENT_UNIT, Unit.TOTAL_ELECTRON_CONTENT_UNIT.alias("tecu"), Unit.EARTH_RADII);
        ALLOWED = new HashMap<String, PrefixedUnit>(base.size() * Prefix.values().length);
        for (Unit unit : base) {
            ALLOWED.put(unit.getName(), new PrefixedUnit(null, unit));
            for (Prefix prefix : Prefix.values()) {
                PrefixedUnit pu = new PrefixedUnit(prefix, unit);
                ALLOWED.put(pu.getName(), pu);
            }
        }
        for (Unit noPrefix : Arrays.asList(Unit.PERCENT, Unit.ONE, Unit.ONE.alias("#"))) {
            ALLOWED.put(noPrefix.getName(), new PrefixedUnit(null, noPrefix));
        }
    }
}

