/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;

public class TimeSpanMap<T> {
    private Span<T> current;
    private int nbSpans;

    public TimeSpanMap(T entry) {
        this.current = new Span(entry);
        this.nbSpans = 1;
    }

    public synchronized int getSpansNumber() {
        return this.nbSpans;
    }

    @Deprecated
    public void addValidBefore(T entry, AbsoluteDate latestValidityDate) {
        this.addValidBefore(entry, latestValidityDate, false);
    }

    public synchronized Span<T> addValidBefore(T entry, AbsoluteDate latestValidityDate, boolean erasesEarlier) {
        Span<Object> span;
        this.locate(latestValidityDate);
        if (erasesEarlier) {
            ((Span)this.current).start = null;
            this.nbSpans = 0;
            for (span = this.current; span != null; span = span.next()) {
                ++this.nbSpans;
            }
        }
        span = new Span(entry);
        Transition<T> start = this.current.getStartTransition();
        if (start != null && start.getDate().equals(latestValidityDate)) {
            if (start.previous() != null) {
                start.previous().setAfter(span);
            }
            start.setBefore(span);
        } else {
            if (this.current.getStartTransition() != null) {
                this.current.getStartTransition().setAfter(span);
            }
            this.insertTransition(latestValidityDate, span, this.current);
        }
        this.current = span;
        return span;
    }

    @Deprecated
    public void addValidAfter(T entry, AbsoluteDate earliestValidityDate) {
        this.addValidAfter(entry, earliestValidityDate, false);
    }

    public synchronized Span<T> addValidAfter(T entry, AbsoluteDate earliestValidityDate, boolean erasesLater) {
        Transition<T> start;
        Span<Object> span;
        this.locate(earliestValidityDate);
        if (erasesLater) {
            ((Span)this.current).end = null;
            this.nbSpans = 0;
            for (span = this.current; span != null; span = span.previous()) {
                ++this.nbSpans;
            }
        }
        span = new Span(entry);
        if (this.current.getEndTransition() != null) {
            this.current.getEndTransition().setBefore(span);
        }
        if ((start = this.current.getStartTransition()) != null && start.getDate().equals(earliestValidityDate)) {
            start.setAfter(span);
        } else {
            this.insertTransition(earliestValidityDate, this.current, span);
        }
        this.current = span;
        return span;
    }

    public synchronized Span<T> addValidBetween(T entry, AbsoluteDate earliestValidityDate, AbsoluteDate latestValidityDate) {
        if (AbsoluteDate.PAST_INFINITY.equals(earliestValidityDate)) {
            if (AbsoluteDate.FUTURE_INFINITY.equals(latestValidityDate)) {
                this.current = new Span(entry);
                return this.current;
            }
            return this.addValidBefore(entry, latestValidityDate, true);
        }
        if (AbsoluteDate.FUTURE_INFINITY.equals(latestValidityDate)) {
            return this.addValidAfter(entry, earliestValidityDate, true);
        }
        this.locate(earliestValidityDate);
        Span<Object> latest = this.current;
        while (latest.getEndTransition() != null && latest.getEnd().isBeforeOrEqualTo(latestValidityDate)) {
            latest = latest.next();
            --this.nbSpans;
        }
        if (latest == this.current) {
            latest = new Span(((Span)this.current).data);
            if (this.current.getEndTransition() != null) {
                this.current.getEndTransition().setBefore(latest);
            }
        }
        Span span = new Span(entry);
        Transition<T> start = this.current.getStartTransition();
        if (start != null && start.getDate().equals(earliestValidityDate)) {
            start.setAfter(span);
        } else {
            this.insertTransition(earliestValidityDate, this.current, span);
        }
        this.insertTransition(latestValidityDate, span, latest);
        this.current = span;
        return span;
    }

    public synchronized T get(AbsoluteDate date) {
        return this.getSpan(date).getData();
    }

    public synchronized Span<T> getSpan(AbsoluteDate date) {
        this.locate(date);
        return this.current;
    }

    private synchronized void locate(AbsoluteDate date) {
        while (this.current.getStart().isAfter(date)) {
            this.current = this.current.previous();
        }
        while (this.current.getEnd().isBeforeOrEqualTo(date)) {
            Span<T> next = this.current.next();
            if (next == null) {
                return;
            }
            this.current = next;
        }
    }

    private void insertTransition(AbsoluteDate date, Span<T> before, Span<T> after) {
        Transition<T> transition = new Transition<T>(date);
        transition.setBefore(before);
        transition.setAfter(after);
        ++this.nbSpans;
    }

    public synchronized Transition<T> getFirstTransition() {
        return this.getFirstSpan().getEndTransition();
    }

    public synchronized Transition<T> getLastTransition() {
        return this.getLastSpan().getStartTransition();
    }

    public synchronized Span<T> getFirstSpan() {
        Span<T> span = this.current;
        while (span.getStartTransition() != null) {
            span = span.previous();
        }
        return span;
    }

    public synchronized Span<T> getLastSpan() {
        Span<T> span = this.current;
        while (span.getEndTransition() != null) {
            span = span.next();
        }
        return span;
    }

    public synchronized TimeSpanMap<T> extractRange(AbsoluteDate start, AbsoluteDate end) {
        Span<T> span = this.getSpan(start);
        TimeSpanMap<T> range = new TimeSpanMap<T>(span.getData());
        while (span.getEndTransition() != null && span.getEndTransition().getDate().isBeforeOrEqualTo(end)) {
            span = span.next();
            range.addValidAfter(span.getData(), span.getStartTransition().getDate(), false);
        }
        return range;
    }

    @Deprecated
    public synchronized NavigableSet<Transition<T>> getTransitions() {
        TreeSet<TimeStamped> set = new TreeSet<TimeStamped>(new ChronologicalComparator());
        for (Transition<T> transition = this.getFirstTransition(); transition != null; transition = transition.next()) {
            set.add(transition);
        }
        return set;
    }

    public synchronized void forEach(Consumer<T> action) {
        for (Span<T> span = this.getFirstSpan(); span != null; span = span.next()) {
            if (span.getData() == null) continue;
            action.accept(span.getData());
        }
    }

    public static class Span<S> {
        private final S data;
        private Transition<S> start;
        private Transition<S> end;

        private Span(S data) {
            this.data = data;
        }

        public S getData() {
            return this.data;
        }

        public Span<S> previous() {
            return this.start == null ? null : this.start.getSpanBefore();
        }

        public Span<S> next() {
            return this.end == null ? null : this.end.getSpanAfter();
        }

        public AbsoluteDate getStart() {
            return this.start == null ? AbsoluteDate.PAST_INFINITY : this.start.getDate();
        }

        public Transition<S> getStartTransition() {
            return this.start;
        }

        public AbsoluteDate getEnd() {
            return this.end == null ? AbsoluteDate.FUTURE_INFINITY : this.end.getDate();
        }

        public Transition<S> getEndTransition() {
            return this.end;
        }
    }

    public static class Transition<S>
    implements TimeStamped {
        private AbsoluteDate date;
        private Span<S> before;
        private Span<S> after;

        private Transition(AbsoluteDate date) {
            this.date = date;
        }

        void setBefore(Span<S> before) {
            this.before = before;
            ((Span)before).end = this;
        }

        void setAfter(Span<S> after) {
            this.after = after;
            ((Span)after).start = this;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public Transition<S> previous() {
            return this.before.getStartTransition();
        }

        public Transition<S> next() {
            return this.after.getEndTransition();
        }

        public S getBefore() {
            return this.before.getData();
        }

        public Span<S> getSpanBefore() {
            return this.before;
        }

        public S getAfter() {
            return this.after.getData();
        }

        public Span<S> getSpanAfter() {
            return this.after;
        }
    }
}

