/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParametersDriversProvider;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class AbstractGradientConverter {
    private final int freeStateParameters;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    protected AbstractGradientConverter(int freeStateParameters) {
        this.freeStateParameters = freeStateParameters;
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
    }

    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    protected void initStates(FieldSpacecraftState<Gradient> zeroParametersState) {
        this.gStates.clear();
        this.gStates.add(zeroParametersState);
    }

    protected Gradient extend(Gradient original, int freeParameters) {
        double[] originalDerivatives = original.getGradient();
        double[] extendedDerivatives = new double[freeParameters];
        System.arraycopy(originalDerivatives, 0, extendedDerivatives, 0, originalDerivatives.length);
        return new Gradient(original.getValue(), extendedDerivatives);
    }

    protected FieldVector3D<Gradient> extend(FieldVector3D<Gradient> original, int freeParameters) {
        return new FieldVector3D((CalculusFieldElement)this.extend((Gradient)original.getX(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getY(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getZ(), freeParameters));
    }

    protected FieldRotation<Gradient> extend(FieldRotation<Gradient> original, int freeParameters) {
        return new FieldRotation((CalculusFieldElement)this.extend((Gradient)original.getQ0(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ1(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ2(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ3(), freeParameters), false);
    }

    public FieldSpacecraftState<Gradient> getState(ParametersDriversProvider parametricModel) {
        int nbParams = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            int freeParameters = this.freeStateParameters + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            TimeStampedFieldPVCoordinates<Gradient> pv0 = s0.getPVCoordinates();
            FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates<Gradient>(s0.getDate().toAbsoluteDate(), this.extend(pv0.getPosition(), freeParameters), this.extend(pv0.getVelocity(), freeParameters), this.extend(pv0.getAcceleration(), freeParameters)), s0.getFrame(), this.extend(s0.getMu(), freeParameters));
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(gOrbit.getDate(), this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gM = this.extend(s0.getMass(), freeParameters);
            this.gStates.set(nbParams, new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state, ParametersDriversProvider parametricModel) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = parametricModel.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = this.freeStateParameters;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)driver.getValue()) : Gradient.constant((int)freeParameters, (double)driver.getValue());
        }
        return parameters;
    }
}

