/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.events.Action;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractDetector<T extends AbstractDetector<T>>
implements EventDetector {
    public static final double DEFAULT_MAXCHECK = 600.0;
    public static final double DEFAULT_THRESHOLD = 1.0E-6;
    public static final int DEFAULT_MAX_ITER = 100;
    private final double maxCheck;
    private final double threshold;
    private final int maxIter;
    private final EventHandler<? super T> handler;
    private boolean forward;

    protected AbstractDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super T> handler) {
        this.checkStrictlyPositive(maxCheck);
        this.checkStrictlyPositive(threshold);
        this.maxCheck = maxCheck;
        this.threshold = threshold;
        this.maxIter = maxIter;
        this.handler = handler;
        this.forward = true;
    }

    private void checkStrictlyPositive(double value) throws OrekitException {
        if (value <= 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_STRICTLY_POSITIVE, value);
        }
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.forward = t.durationFrom(s0.getDate()) >= 0.0;
        this.getHandler().init(s0, t, this);
    }

    @Override
    public abstract double g(SpacecraftState var1);

    @Override
    public double getMaxCheckInterval() {
        return this.maxCheck;
    }

    @Override
    public int getMaxIterationCount() {
        return this.maxIter;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    public T withMaxCheck(double newMaxCheck) {
        return this.create(newMaxCheck, this.getThreshold(), this.getMaxIterationCount(), this.getHandler());
    }

    public T withMaxIter(int newMaxIter) {
        return this.create(this.getMaxCheckInterval(), this.getThreshold(), newMaxIter, this.getHandler());
    }

    public T withThreshold(double newThreshold) {
        return this.create(this.getMaxCheckInterval(), newThreshold, this.getMaxIterationCount(), this.getHandler());
    }

    public T withHandler(EventHandler<? super T> newHandler) {
        return this.create(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), newHandler);
    }

    public EventHandler<? super T> getHandler() {
        return this.handler;
    }

    @Override
    public Action eventOccurred(SpacecraftState s, boolean increasing) {
        Action whatNext = this.getHandler().eventOccurred(s, this, increasing);
        return whatNext;
    }

    @Override
    public SpacecraftState resetState(SpacecraftState oldState) {
        SpacecraftState newState = this.getHandler().resetState(this, oldState);
        return newState;
    }

    protected abstract T create(double var1, double var3, int var5, EventHandler<? super T> var6);

    public boolean isForward() {
        return this.forward;
    }
}

