/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.data.CommonLineReader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class CssiSpaceWeatherDataLoader
implements DataLoader {
    private final TimeScale utc;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastObservedDate;
    private AbsoluteDate lastDailyPredictedDate;
    private AbsoluteDate lastDate;
    private SortedSet<TimeStamped> set;

    public CssiSpaceWeatherDataLoader(TimeScale utc) {
        this.utc = utc;
        this.firstDate = null;
        this.lastDailyPredictedDate = null;
        this.lastDate = null;
        this.lastObservedDate = null;
        this.set = new TreeSet<TimeStamped>(new ChronologicalComparator());
    }

    public SortedSet<TimeStamped> getDataSet() {
        return this.set;
    }

    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    public AbsoluteDate getLastDailyPredictedDate() {
        return this.lastDailyPredictedDate;
    }

    public AbsoluteDate getLastObservedDate() {
        return this.lastObservedDate;
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int lineNumber = 0;
        String line = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            CommonLineReader reader = new CommonLineReader(br);
            line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                if ((line = line.trim()).length() > 0) {
                    int day;
                    int month;
                    int year;
                    AbsoluteDate date;
                    if (line.equals("BEGIN DAILY_PREDICTED")) {
                        this.lastObservedDate = this.set.last().getDate();
                    }
                    if (line.equals("BEGIN MONTHLY_FIT")) {
                        this.lastDailyPredictedDate = this.set.last().getDate();
                    }
                    if (line.length() == 130 && CssiSpaceWeatherDataLoader.isNumeric(line.substring(0, 4)) && !this.set.contains(date = new AbsoluteDate(year = Integer.parseInt(line.substring(0, 4)), month = Integer.parseInt(line.substring(5, 7)), day = Integer.parseInt(line.substring(8, 10)), this.utc))) {
                        double[] threeHourlyKp = new double[8];
                        for (int i = 0; i < 8; ++i) {
                            threeHourlyKp[i] = 0.1 * Double.parseDouble(line.substring(19 + 3 * i, 21 + 3 * i));
                        }
                        double kpSum = 0.1 * Double.parseDouble(line.substring(43, 46));
                        double[] threeHourlyAp = new double[8];
                        for (int i = 0; i < 8; ++i) {
                            threeHourlyAp[i] = Double.parseDouble(line.substring(47 + 4 * i, 50 + 4 * i));
                        }
                        double apAvg = Double.parseDouble(line.substring(79, 82));
                        double f107Adj = Double.parseDouble(line.substring(93, 98));
                        int fluxQualifier = Integer.parseInt(line.substring(99, 100));
                        double ctr81Adj = Double.parseDouble(line.substring(101, 106));
                        double lst81Adj = Double.parseDouble(line.substring(107, 112));
                        double f107Obs = Double.parseDouble(line.substring(113, 118));
                        double ctr81Obs = Double.parseDouble(line.substring(119, 124));
                        double lst81Obs = Double.parseDouble(line.substring(125, 130));
                        this.set.add(new LineParameters(date, threeHourlyKp, kpSum, threeHourlyAp, apAvg, f107Adj, fluxQualifier, ctr81Adj, lst81Adj, f107Obs, ctr81Obs, lst81Obs));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        try {
            this.firstDate = this.set.first().getDate();
            this.lastDate = this.set.last().getDate();
        }
        catch (NoSuchElementException nse) {
            throw new OrekitException(nse, OrekitMessages.NO_DATA_IN_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    public static class LineParameters
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 8151260459653484163L;
        private final AbsoluteDate date;
        private final double[] threeHourlyKp;
        private final double kpSum;
        private final double[] threeHourlyAp;
        private final double apAvg;
        private final double f107Adj;
        private final int fluxQualifier;
        private final double ctr81Adj;
        private final double lst81Adj;
        private final double f107Obs;
        private final double ctr81Obs;
        private final double lst81Obs;

        public LineParameters(AbsoluteDate date, double[] threeHourlyKp, double kpSum, double[] threeHourlyAp, double apAvg, double f107Adj, int fluxQualifier, double ctr81Adj, double lst81Adj, double f107Obs, double ctr81Obs, double lst81Obs) {
            this.date = date;
            this.threeHourlyKp = (double[])threeHourlyKp.clone();
            this.kpSum = kpSum;
            this.threeHourlyAp = (double[])threeHourlyAp.clone();
            this.apAvg = apAvg;
            this.f107Adj = f107Adj;
            this.fluxQualifier = fluxQualifier;
            this.ctr81Adj = ctr81Adj;
            this.lst81Adj = lst81Adj;
            this.f107Obs = f107Obs;
            this.ctr81Obs = ctr81Obs;
            this.lst81Obs = lst81Obs;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double[] getThreeHourlyKp() {
            return (double[])this.threeHourlyKp.clone();
        }

        public double getThreeHourlyKp(int i) {
            return this.threeHourlyKp[i];
        }

        public double getKpSum() {
            return this.kpSum;
        }

        public double[] getThreeHourlyAp() {
            return (double[])this.threeHourlyAp.clone();
        }

        public double getThreeHourlyAp(int i) {
            return this.threeHourlyAp[i];
        }

        public double getApAvg() {
            return this.apAvg;
        }

        public double getLst81Obs() {
            return this.lst81Obs;
        }

        public double getCtr81Obs() {
            return this.ctr81Obs;
        }

        public double getF107Obs() {
            return this.f107Obs;
        }

        public double getLst81Adj() {
            return this.lst81Adj;
        }

        public double getCtr81Adj() {
            return this.ctr81Adj;
        }

        public int getFluxQualifier() {
            return this.fluxQualifier;
        }

        public double getF107Adj() {
            return this.f107Adj;
        }
    }

    @Deprecated
    public static class LineReader {
        private final String name;
        private final BufferedReader in;
        private String line;
        private long lineNo;

        public LineReader(String name, BufferedReader in) {
            this.name = name;
            this.in = in;
            this.line = null;
            this.lineNo = 0L;
        }

        public String readLine() throws IOException {
            this.line = this.in.readLine();
            ++this.lineNo;
            return this.line;
        }

        public String readLineOrThrow(Localizable message, Object ... args) throws IOException, OrekitException {
            String text = this.readLine();
            if (text == null) {
                throw new OrekitException(message, args);
            }
            return text;
        }

        public OrekitException unableToParseLine(Throwable cause) {
            return new OrekitException(cause, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNo, this.name, this.line);
        }

        public String getLine() {
            return this.line;
        }

        public long getLineNumber() {
            return this.lineNo;
        }
    }
}

