/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface PropulsionModel {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    public Vector3D getAcceleration(SpacecraftState var1, Attitude var2, double[] var3);

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getAcceleration(FieldSpacecraftState<T> var1, FieldAttitude<T> var2, T[] var3);

    public double getMassDerivatives(SpacecraftState var1, double[] var2);

    public <T extends CalculusFieldElement<T>> T getMassDerivatives(FieldSpacecraftState<T> var1, T[] var2);

    default public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    default public String getName() {
        return "";
    }
}

