/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.ilrs.CPFHeader;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CPF
implements EphemerisFile<CPFCoordinate, CPFEphemeris> {
    public static final String DEFAULT_ID = "9999999";
    private double mu = Double.NaN;
    private int interpolationSample;
    private TimeScale timeScale;
    private CartesianDerivativesFilter filter;
    private CPFHeader header;
    private Map<String, CPFEphemeris> ephemeris = new ConcurrentHashMap<String, CPFEphemeris>();
    private List<String> comments;

    public CPF() {
        this.header = new CPFHeader();
        this.comments = new ArrayList<String>();
    }

    @Override
    public Map<String, CPFEphemeris> getSatellites() {
        return Collections.unmodifiableMap(this.ephemeris);
    }

    public CPFHeader getHeader() {
        return this.header;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public List<String> getComments() {
        return this.comments;
    }

    @Deprecated
    public void addSatelliteCoordinate(CPFCoordinate coord) {
        this.addSatelliteCoordinate(DEFAULT_ID, coord);
    }

    public void addSatelliteCoordinates(String id, List<CPFCoordinate> coord) {
        this.createIfNeeded(id);
        this.ephemeris.get(id).coordinates.addAll(coord);
    }

    public void addSatelliteCoordinate(String id, CPFCoordinate coord) {
        this.createIfNeeded(id);
        this.ephemeris.get(id).coordinates.add(coord);
    }

    public void addSatelliteVelocityToCPFCoordinate(String id, Vector3D velocity) {
        CPFCoordinate lastCoordinate = (CPFCoordinate)this.ephemeris.get(id).coordinates.get(this.ephemeris.get(id).coordinates.size() - 1);
        CPFCoordinate CPFCoordUpdated = new CPFCoordinate(lastCoordinate.getDate(), lastCoordinate.getPosition(), velocity, lastCoordinate.getLeap());
        this.ephemeris.get(id).coordinates.set(this.ephemeris.get(id).coordinates.size() - 1, CPFCoordUpdated);
    }

    public void setInterpolationSample(int interpolationSample) {
        this.interpolationSample = interpolationSample;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
    }

    public void setFilter(CartesianDerivativesFilter filter) {
        this.filter = filter;
    }

    private void createIfNeeded(String id) {
        if (this.ephemeris.get(id) == null) {
            this.ephemeris.put(id, new CPFEphemeris(id));
        }
    }

    public static class CPFCoordinate
    extends TimeStampedPVCoordinates {
        private static final long serialVersionUID = 20201016L;
        private final int leap;

        public CPFCoordinate(AbsoluteDate date, Vector3D position, int leap) {
            this(date, position, Vector3D.ZERO, leap);
        }

        public CPFCoordinate(AbsoluteDate date, Vector3D position, Vector3D velocity, int leap) {
            super(date, position, velocity);
            this.leap = leap;
        }

        public int getLeap() {
            return this.leap;
        }
    }

    public class CPFEphemeris
    implements EphemerisFile.SatelliteEphemeris<CPFCoordinate, CPFEphemeris>,
    EphemerisFile.EphemerisSegment<CPFCoordinate> {
        private final String id;
        private final List<CPFCoordinate> coordinates;

        @Deprecated
        public CPFEphemeris() {
            this(null);
        }

        public CPFEphemeris(String id) {
            this.id = id;
            this.coordinates = new ArrayList<CPFCoordinate>();
        }

        @Override
        public Frame getFrame() {
            return CPF.this.header.getRefFrame();
        }

        @Override
        public int getInterpolationSamples() {
            return CPF.this.interpolationSample;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return CPF.this.filter;
        }

        @Override
        public List<CPFCoordinate> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        @Override
        public String getId() {
            return this.id == null ? CPF.DEFAULT_ID : this.id;
        }

        @Override
        public double getMu() {
            return CPF.this.mu;
        }

        @Override
        public List<CPFEphemeris> getSegments() {
            return Collections.singletonList(this);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }

        @Override
        public BoundedPropagator getPropagator() {
            return EphemerisFile.EphemerisSegment.super.getPropagator();
        }

        public List<CPFCoordinate> getEphemeridesDataLines() {
            return this.coordinates;
        }
    }
}

