/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.orekit.files.ccsds.definitions.ElementsType;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.ndm.odm.ocm.Ordering;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public class CovarianceHistoryMetadata
extends CommentsContainer {
    private String covID;
    private String covPrevID;
    private String covNextID;
    private String covBasis = "PREDICTED";
    private String covBasisID;
    private FrameFacade covReferenceFrame = new FrameFacade(null, null, OrbitRelativeFrame.TNW_INERTIAL, null, OrbitRelativeFrame.TNW_INERTIAL.name());
    private AbsoluteDate covFrameEpoch;
    private double covScaleMin;
    private double covScaleMax;
    private double covConfidence;
    private ElementsType covType;
    private Ordering covOrdering;
    private List<Unit> covUnits;

    CovarianceHistoryMetadata(AbsoluteDate epochT0) {
        this.covFrameEpoch = epochT0;
        this.covScaleMin = 1.0;
        this.covScaleMax = 1.0;
        this.covType = ElementsType.CARTPV;
        this.covOrdering = Ordering.LTM;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (this.covUnits != null) {
            this.covType.checkUnits(this.covUnits);
        }
    }

    public String getCovID() {
        return this.covID;
    }

    public void setCovID(String covID) {
        this.refuseFurtherComments();
        this.covID = covID;
    }

    public String getCovPrevID() {
        return this.covPrevID;
    }

    public void setCovPrevID(String covPrevID) {
        this.refuseFurtherComments();
        this.covPrevID = covPrevID;
    }

    public String getCovNextID() {
        return this.covNextID;
    }

    public void setCovNextID(String covNextID) {
        this.refuseFurtherComments();
        this.covNextID = covNextID;
    }

    public String getCovBasis() {
        return this.covBasis;
    }

    public void setCovBasis(String covBasis) {
        this.refuseFurtherComments();
        this.covBasis = covBasis;
    }

    public String getCovBasisID() {
        return this.covBasisID;
    }

    public void setCovBasisID(String covBasisID) {
        this.refuseFurtherComments();
        this.covBasisID = covBasisID;
    }

    public FrameFacade getCovReferenceFrame() {
        return this.covReferenceFrame;
    }

    public void setCovReferenceFrame(FrameFacade covReferenceFrame) {
        this.refuseFurtherComments();
        this.covReferenceFrame = covReferenceFrame;
    }

    public AbsoluteDate getCovFrameEpoch() {
        return this.covFrameEpoch;
    }

    public void setCovFrameEpoch(AbsoluteDate covFrameEpoch) {
        this.refuseFurtherComments();
        this.covFrameEpoch = covFrameEpoch;
    }

    public void setCovScaleMin(double covScaleMin) {
        this.covScaleMin = covScaleMin;
    }

    public double getCovScaleMin() {
        return this.covScaleMin;
    }

    public void setCovScaleMax(double covScaleMax) {
        this.covScaleMax = covScaleMax;
    }

    public double getCovScaleMax() {
        return this.covScaleMax;
    }

    public void setCovConfidence(double covConfidence) {
        this.covConfidence = covConfidence;
    }

    public double getCovConfidence() {
        return this.covConfidence;
    }

    public ElementsType getCovType() {
        return this.covType;
    }

    public void setCovType(ElementsType covType) {
        this.refuseFurtherComments();
        this.covType = covType;
    }

    public Ordering getCovOrdering() {
        return this.covOrdering;
    }

    public void setCovOrdering(Ordering covOrdering) {
        this.refuseFurtherComments();
        this.covOrdering = covOrdering;
    }

    public List<Unit> getCovUnits() {
        return this.covUnits;
    }

    public void setCovUnits(List<Unit> covUnits) {
        this.refuseFurtherComments();
        this.covUnits = covUnits;
    }
}

