/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum SpacecraftParametersKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setMass)),
    SOLAR_RAD_AREA((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setSolarRadArea)),
    SOLAR_RAD_COEFF((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setSolarRadCoeff)),
    DRAG_AREA((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setDragArea)),
    DRAG_COEFF((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setDragCoeff));

    private final TokenProcessor processor;

    private SpacecraftParametersKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, SpacecraftParameters container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, SpacecraftParameters var3);
    }
}

