/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.ModifiedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.VersionedITRF;
import org.orekit.utils.IERSConventions;

public enum CelestialBodyFrame {
    EME2000{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getEME2000();
        }
    }
    ,
    J2000{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getEME2000();
        }
    }
    ,
    GCRF{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getGCRF();
        }
    }
    ,
    GRC{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRFEquinox(conventions, simpleEOP);
        }
    }
    ,
    GTOD{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getGTOD(conventions, simpleEOP);
        }
    }
    ,
    ICRF{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getICRF();
        }
    }
    ,
    ITRF2020{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2020, conventions, simpleEOP);
        }
    }
    ,
    ITRF2014{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2014, conventions, simpleEOP);
        }
    }
    ,
    ITRF2008{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2008, conventions, simpleEOP);
        }
    }
    ,
    ITRF2005{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2005, conventions, simpleEOP);
        }
    }
    ,
    ITRF2000{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_2000, conventions, simpleEOP);
        }
    }
    ,
    ITRF1997{

        @Override
        public String getName() {
            return "ITRF-97";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1997, conventions, simpleEOP);
        }
    }
    ,
    ITRF1996{

        @Override
        public String getName() {
            return "ITRF-96";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1996, conventions, simpleEOP);
        }
    }
    ,
    ITRF1994{

        @Override
        public String getName() {
            return "ITRF-94";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1994, conventions, simpleEOP);
        }
    }
    ,
    ITRF1993{

        @Override
        public String getName() {
            return "ITRF-93";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1993, conventions, simpleEOP);
        }
    }
    ,
    ITRF1992{

        @Override
        public String getName() {
            return "ITRF-92";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1992, conventions, simpleEOP);
        }
    }
    ,
    ITRF1991{

        @Override
        public String getName() {
            return "ITRF-91";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1991, conventions, simpleEOP);
        }
    }
    ,
    ITRF1990{

        @Override
        public String getName() {
            return "ITRF-90";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1990, conventions, simpleEOP);
        }
    }
    ,
    ITRF1989{

        @Override
        public String getName() {
            return "ITRF-89";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1989, conventions, simpleEOP);
        }
    }
    ,
    ITRF1988{

        @Override
        public String getName() {
            return "ITRF-88";
        }

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getITRF(ITRFVersion.ITRF_1988, conventions, simpleEOP);
        }
    }
    ,
    MCI{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getCelestialBodies().getMars().getInertiallyOrientedFrame();
        }
    }
    ,
    TDR{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getGTOD(conventions, simpleEOP);
        }
    }
    ,
    TEME{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            return dataContext.getFrames().getTEME();
        }
    }
    ,
    TOD{

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP, DataContext dataContext) {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return dataContext.getFrames().getTOD(conventions, simpleEOP);
        }
    };

    private static final Pattern DASH;
    private static final String INERTIAL_FRAME_SUFFIX = "/inertial";
    private static final String ITRF_SUBSTRING = "ITRF";

    public abstract Frame getFrame(IERSConventions var1, boolean var2, DataContext var3);

    public String getName() {
        return this.name();
    }

    public static CelestialBodyFrame parse(String frameName) {
        int year;
        String canonicalized = DASH.matcher(frameName).replaceAll("");
        if (canonicalized.startsWith(ITRF_SUBSTRING) && canonicalized.length() > 4 && (year = Integer.parseInt(canonicalized.substring(4))) > 87 && year < 100) {
            canonicalized = ITRF_SUBSTRING + (year + 1900);
        }
        return CelestialBodyFrame.valueOf(canonicalized);
    }

    public static CelestialBodyFrame map(Frame frame) {
        String name = frame.getName();
        try {
            return CelestialBodyFrame.valueOf(name);
        }
        catch (IllegalArgumentException iae) {
            if (frame instanceof ModifiedFrame) {
                return ((ModifiedFrame)frame).getRefFrame();
            }
            if ("Mars/inertial".equals(name)) {
                return MCI;
            }
            if ("solar system barycenter/inertial".equals(name)) {
                return ICRF;
            }
            if (name.contains("GTOD")) {
                return GTOD;
            }
            if (name.contains("TOD")) {
                return TOD;
            }
            if (name.contains("Equinox") && name.contains(ITRF_SUBSTRING)) {
                return GRC;
            }
            if (frame instanceof VersionedITRF) {
                try {
                    ITRFVersion itrfVersion = ((VersionedITRF)frame).getITRFVersion();
                    return CelestialBodyFrame.valueOf(itrfVersion.name().replace("_", ""));
                }
                catch (IllegalArgumentException iae2) {
                    throw new OrekitInternalError(iae2);
                }
            }
            if (name.contains("CIO") && name.contains(ITRF_SUBSTRING)) {
                return ITRF2014;
            }
            throw new OrekitException(iae, OrekitMessages.CCSDS_INVALID_FRAME, name);
        }
    }

    public static String guessFrame(Frame frame) {
        try {
            return CelestialBodyFrame.map(frame).name();
        }
        catch (OrekitException oe) {
            return frame.getName();
        }
    }

    static {
        DASH = Pattern.compile("-");
    }
}

