/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TDOA;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.TDOAModifierUtil;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class TDOATroposphericDelayModifier
implements EstimationModifier<TDOA> {
    private final DiscreteTroposphericModel tropoModel;

    public TDOATroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    private double timeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double delay = this.tropoModel.pathDelay(elevation, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            return delay / 2.99792458E8;
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T timeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D pos = state.getPVCoordinates().getPosition();
        Object elevation = station.getBaseFrame().getElevation(pos, state.getFrame(), state.getDate());
        if (elevation.getReal() > 0.0) {
            CalculusFieldElement delay = this.tropoModel.pathDelay((CalculusFieldElement)elevation, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            return (T)((CalculusFieldElement)delay.divide(2.99792458E8));
        }
        return (T)zero;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<TDOA> estimated) {
        TDOA measurement = estimated.getObservedMeasurement();
        GroundStation primeStation = measurement.getPrimeStation();
        GroundStation secondStation = measurement.getSecondStation();
        SpacecraftState state = estimated.getStates()[0];
        TDOAModifierUtil.modify(estimated, this.tropoModel, new ModifierGradientConverter(state, 6, new InertialProvider(state.getFrame())), primeStation, secondStation, this::timeErrorTroposphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, timeErrorTroposphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((TDOATroposphericDelayModifier)this));
    }
}

