/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.modifiers.BaseRangeTroposphericDelayModifier;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.RangeModifierUtil;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.SpacecraftState;

public class RangeTroposphericDelayModifier
extends BaseRangeTroposphericDelayModifier
implements EstimationModifier<Range> {
    public RangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        super(model);
    }

    @Override
    public void modify(EstimatedMeasurement<Range> estimated) {
        Range measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        RangeModifierUtil.modify(estimated, this.getTropoModel(), new ModifierGradientConverter(state, 6, new InertialProvider(state.getFrame())), station, this::rangeErrorTroposphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, rangeErrorTroposphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((RangeTroposphericDelayModifier)this));
    }
}

